(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     97059,       1853]
NotebookOptionsPosition[     93558,       1785]
NotebookOutlinePosition[     93897,       1800]
CellTagsIndexPosition[     93854,       1797]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell["\<\
This Notebook contains supplementary material related to the paper
Stanley Rabinowitz, \[OpenCurlyDoubleQuote]Relationships Between Six Circles \
Associated with a Triangle\[CloseCurlyDoubleQuote], 
submitted to the International Journal of Computer Discovered Mathematics, \
October 2019.
http://www.journal-1.eu/

This Notebook is Copyright \[Copyright] October 2019 by Stanley Rabinowitz \
(stan.rabinowitz@comcast.net) and is published with open access. This \
Notebook is distributed under the terms of the Creative Commons Attribution \
License which permits any use, distribution, and reproduction in any medium, \
provided the original author and the source are credited.
------------------------------------------------------------------------------\
\>", "Text",
 CellChangeTimes->{{3.77602941072921*^9, 3.776029415463889*^9}, {
  3.776029483519946*^9, 3.7760295042638693`*^9}, {3.776261082594401*^9, 
  3.776261180210319*^9}, {3.776261262802527*^9, 3.7762614216668177`*^9}, {
  3.7762614917472763`*^9, 3.776261550442977*^9}, {3.776261588698138*^9, 
  3.7762616175952168`*^9}, {3.7762617208677483`*^9, 3.776261729802679*^9}, {
  3.780343841826885*^9, 3.780343934037478*^9}, {3.780343965525668*^9, 
  3.780343972580963*^9}},ExpressionUUID->"e3fe5dcd-4659-46ac-917f-\
8466aef53435"],

Cell["Empirical Discovery of Theorem 1", "Text",
 CellChangeTimes->{{3.775839748172928*^9, 
  3.775839760956171*^9}},ExpressionUUID->"a7db9f21-9863-4737-ba43-\
5b65d529f88c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{"===", "===", "===", "===", "===", "===", " ", 
   RowBox[{
   "A", " ", "R", " ", "B", " ", "I", " ", "T", " ", "R", " ", "A", " ", "R", 
    " ", "Y", "  ", "P"}], " ", "===", "===", "===", "===", "==="}], " ", 
  "*)"}]], "Input",
 CellChangeTimes->{{3.775663109788237*^9, 3.775663118731946*^9}, {
  3.775663221892283*^9, 3.775663245484207*^9}, {3.7758397368126574`*^9, 
  3.775839741804377*^9}},ExpressionUUID->"ce88380c-4612-4430-ad11-\
b98476848d44"],

Cell[TextData[{
 Cell[GraphicsData["PDF", "\<\
9E14ARda;S<:9LCUl^G[Yo>Pd<C62S@P<21_HVX:?3`P;daUKVMdJ20e830PDR0_
AVU/M6Eb82m6K65dIDAUHfmTIB0n?PYcM79UHFd:N06=ET]_fc0<_^]Gl3H7@eeA
OV[0;RefjJf8Kl<>VmNQ:1H<K@Kdkhl?DEKL>2/2>7ZBgoNAX_@<mo0<3K`2`Qd4
N8;[fb?2kAjlo?Jg=8gB_>:o9TBH3h2nZC_jdXLkg1kK^W>oHDl6aLAlC2J>LcJ1
d0D8KLlVKRK084_BggB0jfU2lSKmP^[kcTe?l6DBO?l148J<01B1HBI[HdLNPo^o
aalk<8nnS^<HVZh1Gg_Oa81M7kTMQ[KcLG@K/TAO]kj;[JXQdVBMgP3c;@A/g`7/
K`5<13__gBea8<l[:6__C@oHh4HLG167Wh]c4kE<Q9FK0jaRhCRm=7`DRmiOl5Y6
of7aRYBK_/K@]M47Ue/d5SPDY>9i>F0L:2e3Tg:Dhj0MUL8kC_2=[J6[hn270D9X
jXKS^=i^Y4`;3V>aR7C89YZQ7U9JU^PCXl/la2bFA5CO4bHGLX9PS9BeTDhM`g0F
Wg;oVPXWANV5^IPATD<4M;J=cWB4cU/ZmGZTmNoTB7n5JTnYC763R^9k9HeGKCPj
kfWTaMIlh;D8eA5f@18<D4eYmj>]cFKnf<S;`ljYiL>W7Gb3jNjdQPQJc0EX6bd3
VYkLB@52j4Lj/dKe@_D:Boh^>PeD9G/kkm^NBJO<RjR;C1nYLHh<n_0^VeEAg1I0
R;Q1aie4[SY;1g4TgbK69Qm7O:R8J52<cnL]?Re[]66c;4]5CBch]7633jci_;UL
4:S6Ko/^RQ?aVHd7aHE:4RGdW2UBk<i5:TJ8VMSic75lkle;iR1E>;VH2A/D]jSE
79H9jMIMKQ_]m?GP8cX<l/nGdLR;m8kTiPaS7J8ONc8/LkdHdGfP7CHeYgKPeM4E
VlBF6^C_C5MiMRK3RT@gUR1WN8BKhU8X^M3U:SShbbE8N`UE6=A3@VcG3=5a<hAN
/4FKk4l8QMAUNkaF9a>fHR/1MfIGFAE>NL0PfMH2[o0jleJA0^jiP>O7TWBbG;hC
hI96nZaBX>PY0DQgWHZAd6FE^JLFIi1fRTe3PfVG/1Akg:88VBNM81@FD=jD4FhA
hFB;kNYiH`<>aaBV6>XN>dnE@A:[N1jTa1][S?eXRDOKk<6D/[HHDAV:PJ@kFCHK
79G2QdK=<10ZVEm@9`<6Vd2Z3lY9R]gm?mU[=hh:IFiTLgAbIF5]2VE^I6mRJPXe
830PKf9Z2SPf<`YUKVA_HVX:<R0`86mRJPXl?20_E7U`IB0_D65WIB0_D65bIFid
83<P<21B82mBIG=_MG9SIG<P=R0`858P;d=_KWAUKWAc83@P<21B82m=IFAYHD9_
N21K<20`838h<20c<SUM2Shn2VE^I6mRJPXf830PKf9Z2S`l82m@LVmSDfEd85/P
;e14AR0_E6EhM21M82m3Kfa_LU=`HF=U83`l82m3Lc4P=b0`858P?ShP;dI_KW@P
?3`P;eAD<B0h830PDPXn?R0n?PYUKVA_HVX:>B0`86mRJPXl?20_C6E^IgAX834`
830PDR0_CR0c82m1K7AULViQM6DP;dAUMVUSIE97@R0_AVU/M6Eb82m6K65dIDAU
HfmTIB0n?PYcM79UHFd:N06MUWMDDmTFQlnm=kg@4R8P9O@JNPTPdS]85@AARDV0
D0:6Q2IfA0E6514YEVAD`057Qb9SAA@;Ph9Re`Wb4536`E54ANGMS6/9kjdelmjJ
oLMIgmWW]mOIInmmekX0D?b21<9dF060=:5H5>k[`E`B4l_4m`8H404>F070hFIV
14OhA0;Do;dmVIVXB<Jcm^h^P6BkfbboD2Ice_moTB8g@b@600Y5eCHlORHGi@:D
Dk?56C;o1<[dUBTbQS4b5Z49XZ`RhlB_K?JWiR^kbIRG9^BQ6UW>6K`dWXbkD=jJ
9N6SS0BQG9PUh6NSO0MU_EA9VP3UmbSCdoRLC00`59UOc>LVXFb9<TDD6Nj9lP80
29C4>Kab3X_i>FRN07RVInB:18U9HZHAeiQYiNS8I_[a/e?iHS4[U<==hHQhC<od
]0b><1N0[fnFA@4UFFfIJ97][Ac]kEWFiVSi_mWO7WiCoCg8N_]ElBK/cii1S9iI
gfc/[2nm5P3f95ZK7K>nUED0]6d6@>GQ[4o_803b1@2dgYcc7XI/GY;4hP`W2h_/
k6ac0Im[;R_X=o^OPVo:_hHimiW;k_]F>jHG?h4SBADcIDGUYZNVBdC<c0`>UlmT
oOL@on?0>FW=bL</W9o05o65j5EAj9@9Q8UX^hDlPER@;V@:Q7oEhGlH=RL76GjM
JaAXMEl0OHDiD;Q91lQ_?@138`<TKSmj0Wg[Fa0a2/Rn_6R]TJmcSc9jo^Oj7`]L
RVkQC44RDnKf38mTLRFR;1VSghA/`@8BT0MdX0XdPBh`0RaP3Ab0<g03gR00Q818
40>F0bi80VU01;91?]P02T4af05fPfY`0=B1N]04CX8fL0IL15O03G0;3817@0Z6
`D/`0Mj1J@R2l10EXT6ZT1JT3iU2eQ0KFPQi@d5@>1@3aD>9T12B@?W@9ZPH:X>Z
XD=@?O@SM1Zj25f3nZ07d20d1_d1OH@AV0;CH@gH0;J0fK0k70Q7`/_PA7PEW0LG
`=_QB[PF?Pjg`QOQ6o00;8EO`Y<8@<P80m56F0PKlDA2T5PT0A4QJi4RY0:YAIZ@
3Z@K^He8TG7T0`J7XF6H61K66N>7FHcQHUIQeV9:<=FHHiQFC1OV=VH@<h7iPZER
eK6VF2N/?gH9=Q6KSBg4EV2?H5^`Uk43f67/>a`>al0IhQa`O[PHG39^=Jh4]`oG
S;^0jl<=hBKaN;`ZgQC_PPo1Lo1RO26n2WlLOakOSao6_bN@2EX4Jh8?8IHP96`T
E10J2>L8oH@A`SAAPJQ?M2:647W4G68Y/HkH@Ka972I>TaA9QR@GDR@YVKB1E4UZ
8UdV?BJm8I?9>VA7LQQI@5i?[RBO85lU3i8oD9@X9QA?BQa5@]U>>DZi@7U0ND>U
DPfXK]AHZYRjWEY?_DAmBWd_Ai<cUo>GhlV]Tj^AJiG[Ug/UCiCGUgNGGbjO9elQ
Od[nY_bh0U71@<5CPJ>`EZ56hKC2?HE9AIZRUF:8HYYRRF:3hSG5DBFlTX6B]a9?
ZD3Y/=8UYB4J@]>UNM:h]4fd>]YUfS0MAcNTnm>CjLGd7nRmm0UU9FEKiBSU7>DJ
iK?:DPK2<63h<e8IYHbCS;^<So<di[W?hloK=ZmYG_nl:IGi:VhZO9DRUFJE0IF?
ZTaEKmDDeIfZKJY?e31Z9VYQJ]UZnmD^Zhg?YlmgW/nMGcCoi?b7j[2jRGZhnV[e
`nXmjY<JVQZn6QTJEAZG=<He6IY^V/VJiI[W=<NdJ5X;]@AJiE[W]Eh`UIW^c5AV
9K>;>J6][^fW;M4nY=f[?JeSZ;=HIj=>/lhCGI8^FcM1]ebgDgM2Cd/_F2mO[e7_
XCiAWjfOY;m7_e]ob/3@8=YPRd6K`JRQRZ6oHIiQXn5S8jZAZm4ZXeZS>lHhHkIa
R_4nhe/V/8VMBI99SLU=DmSDgUAP^/ndc`a[iVPV=:/e^lNR/=aIFJa6eZ0i`cc8
O:=iVoT[2cf;F8^M5]dFGbc];5<]jb`OFBUI1EQ]]>Z`n/?Ja9Y[GF=mahIZhf>c
cZKMi[F]ZBgOM[o]OC^JGK3M5[]>^lof3_HRnbKk<@LmQgR7_@kgf7Af:;^4OMDA
jnSQ^<kaS><79g/W/M=9YmnMFLhYcPg>X`/<5o0Ge2dHL]5ahKPLLY4^I2j<GgQ`
XMAEfiGSF^_jc4gGSNMfa6g4gMPmfOfhnb/?B`nAAh_7U:NCia[?2ej8UjmGTEN_
]i;gH^mZkjLn>Sj9?Xdn4kif_Z]m;oQQo@;mM_[MlmO`io[Gndl4>0B/2NP:Y0A6
15H7?P/b2A85M@C3`@71^h8O;m9O95cD5P92o4=fQC`9=@aM5OYc62h/=:`Vk7Vh
EGQnN7L4;F95A4?4^dR?b=;8Ah^=5T/FMdK9AlE5eDM=AG]5UdE;UeP/FK?TAXaJ
S22V?AHO6aEk97IbZOOBgD^7hncR2^?^;S=LU[?/fW:eiJW;cjj@Gl5ILBXN6alM
ga3oRA?2ZNE<[_AO^GOU1=NC^hOkT^O6:nN=lEghIObA19N4/XCAA9O4GHUSBJi9
5DWS0Tm1]N1e/UobPNBYU92DXbTcZM6YcFV4]?Rddd8UHHZ`:edc?BNm;l<dXc13
^/YYeNiE4j90dI5<:7=II[^HS_i<mDR<99/UPeT;/fZbgVM7IIo:DL`Ai_CTV^A^
bag9llWkOSEV=GMeIkifoXKl`CG^J`j]QMJ^G=^iCWMM`K[QmKk[SfdPKDSIl<]6
bheU6mm^R]kDDJ1A/;iPJ;?_i/I2^D9AhKd]cU/>K<E/5Fc]gFJc[F[KUb9NdOER
bn::hTlUg9;[geUmEoWMc?J4kKfUmZGkMn1f27OLgNVjleRIHUUNfM2^h5f]iLcb
X_:g^eO/_UIQFg5P3fV?I8nd<ZRb_DZ_JTOEYnZTjX4JSi[V_NYk]nfMf/OKekoO
KGoC0Hd3a@Ln7Q@L_7o8me1[[D5]aF7LhJc3cn^Rj[ZoIgmOOdC]B?6AcdN5AjG7
`XmeeC_DecNX=i@f`XfBa[7SLLM_oN3e@g/CZnU@<j>in0@h8CWah/Oh7nnN33cI
NHYmZ^TWoIof]]1JRUZQe]cFRKJT=VUkC7_OjH3CWAg>7BdoVomlm8cfVIZcbVM;
ci7>5IbK>ImgO_92aXGaRhTGQcYGM3jj]>CBWJj`[]k;PIN_G_6iLZWK_O_lEIN[
IjhiGC]mWGfmkHKmSMHN^ijFGnanJNVekffmjG2coIKS[Hjn1GgWnUgk;mkf^WgU
S_nM6`>;1_[^;[ikoekL?NUmg_gA1jT?GSo<NSSmJ?eSk>>R9`Y?:YjZ?jgmeOSG
IZVmm>bPef3?/hQWShJh@booUOV_Cl<5cjW?:dJdA^Y7[DO?S?V<gGZam<G`bhbG
dn>5_bWn]_NEdJ^OOWOk_FMRbLC`Jm7[VCm:gZRn>O[FmVgWI>STdgMYkjJWR]j[
_SofPOfQnf?dai7Yk4ohCiFOSCmgO0WllWPVKFKVgoN4lo/:IFiTLgAbIF5]2VE^
I6mRJPXa<20`86mRJPXb=S4b2VE^I6mRJPXg830PKf9Z2U/P;dU3@d9QLfET83TP
<21B85d:IFiTKf9Z2S<P<21_HVX:?3`P;eAiL6DP;e1QIfEc82m=IFAYHD9_N21K
<20`838h<20c<SUM82m3KgE^M20a82m;JFAc85/P<R0`858PGB0n?PYUKVA_HVX:
<C4P<21_HVX:?3`P;eAiL6DP;d=QM65/KfLP;e1QIfEc83<P<21B83hn2VE^I6mR
JPXh830PKf9Z2S`l82mDNG1U82m6Kfid82mCMF9dNG1U82mDLWEUE7U`IB0_@V5c
IDI_KW@P;d98@dU8@b]8IFafIGAYHf4P;dI_KWA4IG=SLVU`M6mb2S4b830PDR0_
AFiSKfAYKVLP;deQHe9_KF5^AFiSKfAYKVLP;dIYLW=d@fQQLR0c<R0_C65cM4=X
HG8P<C4i82mGJFAdJ7<PFb0b=cP:<20`830P<20`830P<CTa830P<20`83Dh=20`
830P<20`830P<20e=CHP<20`830P<20`830P<20b=cPP<20`83Dh=20`830P<0X`
830P<20`830P<20`830P<20`830P<20`830P<20`830P<20f=SLP=S4a830P<20`
830P<20`830P<20`830P<20`83De=R0e=CH:=C0`83De=R0e=CHP<20`83De=R0`
830P<20`83Pc<b0`83De=R0`830P<c<c83D`<20b=cPP<20`83Lb<R1M83hn2VE^
I6mRJPXa<R0`86mRJPXl?20_E7U`IB0_AVm^M4AULf=bJG1dKg8P;dI_KWA>HFeU
82m2B4=9B4<[B6E/MVEdJF=Q82m6K65WLb0c<R0_AVm^M492KgPPFbdi=C4P;C@h
<B0a=3@e834a<S9M2Rm9M65/JF=1KVM/IB0`82m1Lf=UKW@P=cL`82m4IG=SIFid
82db<c0P;d=QL4QUJFMXM20g<CLP;e=dIFeF83Th82mHB6EYIfQd2SDb<b0_DgAU
KDPP>3DP;d5fIeMYI7AX83@d<B0_CF5hEfUTM6PP<CD`<20_AVm^M4IYK6Db834c
830PDR0n?PYUKVA_HVX:<C<P<21_HVX:?3`P;daUKVMdJ20a=20`858P;daUKVMd
J34P<C0a<S0P;dIYK7AULR0_AVaQM6E4IF=_I6DP?Sh:LgAbIF5]2WP1_CYiO5CE
eNNnIMjK9I=I<d]V<_<bVIW/:`T92F@8fB2;T20TB3@91<9F0XH8E6QD:10@AF@A
[1Fe443;429<A?b@XXSmZVQEU5Z[1IL^:Ogj8Il2VOW>Na=BTUIoo>6_kleMc[gg
gG^fNliimdgkdVD]406M@<?T6De]Ld2jg9l2T>iIRi[J`[2Nao:=FAg]cS3<aP?@
2nNdcEdDQ_W70ACf^@]G33j__`6PKFm]JIXMkPN48JLE6l8`6HEUG>^Rm^EQF=N;
iMB5RfL=m^_?8IblZ6Wih?[`<L;>7cD]JPV?Mkn<IEcKhW_K1f5aG6GKdYK1lJ@>
lG/K2;HJhC6@``;PP08=gPd0g5L:>c3H:oKSEMgelU?gA1Il3EZAC81kZQjAb_>_
MCohCL/=[g8;obdfb6n>5d]I@S01@4F`_eniIJQ7NPhcH`1ZT`8`4E<QYVa<BDWS
cM19m/:SV9k6A<<l/Q5FH=Z0j@U<c51]?d9mI6<?`o]N8R_0BRKiU8aSZ/7R<2^D
SWL3A=KkU><SllGSa8;BnhaHNR90?Ui1WRHoQmWP8;l0=eT9iA1?MQe9F>QXa:km
d8JY4a<]iHC/khW9M;a2T/7=47c60c4<>N[h<R?5lGU6P28mSU?N08?5Zc48nB8M
9ne?>Ok;?]Oa2ZJ3hJh32CSRZ6>oOJ5SJdb0k>Ya?6H?47aVBkQHI/M7ScXF9Fag
c<j@nR^g1jR3?Hhlk9oVDcYbLPE7]_fB8ldKh0W2:OI:Af;6Kaaan20>Ln:TKYoF
HK=_MHc1[QQkRGL<Y^?T0=T=RFAgSg^BhbF/8[U79RKTKPn@7alYSlm`1lQ:Gdii
o?J4LZlkXM;QCRSeN[4nk@e^3GLG=ik;i9:hN<k32E`dIn1e_8IGlbYN`O<l5b3?
ma@jI<O9@BQ4]Q`l`/]h=T1nRHg<LO:2e?S2<IkQ:Aih@b3d:BX_0D>07>cER3F/
79E9=EV0_70Tg?B2cl68=DKZd51R7C?<PB8l1I?0Cah>b61]E4NQ^E0gCY]GF_aM
FJ?DLc=?n^k;C>cnkAFeMOh3mWYoYUP9fN]_3SOO[7aWfKh<^eZ:TY8ZJUHLjFRK
?jNTaEGBj2YY`MCXgmSAJ_Ig=S^MQnNgRAe>?neYK9kE:YI=;OhfEd^aOkj[f7Vh
@gY^A?LL/K_3EG`HiYA<[C/lamMBg=?QjbQa=AGG7fT^F]X`K:d=@f/];OXgJaF9
TbdEefZFWQ^aEX?HgBb^eB2^eB2^eNa[U]HBRBnIEe]dKc]ZYk=TGXGC7eo[WcQU
AYgOfEAO721k/K5h6K0W@L>NP7Rf4ja<6SP0@QmQ^R2F`C]3Gk1W@1=L5?XO>Qn5
fRLV:UQH02OQHMP=Qd06gER?Qk]Q9i`Ulg5_chANn834@2[JGPH2D0WoCD:QMf0>
?8OSfn4DK8?3X<9W5Z4=ZhC=a1eJRK0?jlf`9_@<a44^o1A>@1k>^QWj@o]3Ak2g
1^j40g0@WoleLE676GgXUj5;`<<DW7<=m[`CZP`M0QdT@a5<a]Hel0YadaM2[F26
O<C^BOPik85GhJoT@M8KJPeeQ<j5?T=E=H<=J_5NAG[9Io@QiZNQ9d=o3PFA4o6@
R:/f`UIh5^LoQ?M9=:dUI05Y9e_9=/Y7?DSe<V]IDg00nI00IGRG`f9HSacXPm?`
3oRFG:K<]8I^Yel;IHOn5iA@PEB:U;A01mk[l=j<=1dW<Y9>9Y39I1EiW6`S_jDB
ZC^Y>^XnJSWe1Ee=cjAGd;mUkVEjf4g/CYTbn7GXN>Q<j7d`PAg^PZF`6ZTk1NOP
2U`S=<iU8fjBCh[8gGQgT]eD7mU3nZS9i2@iAadPOb0GbFEbWF8Y5FFTTZQfJR]e
T3Y5_DG?XkOACm1oX;mVa[4D^hOmG>KVOQM/3Vh8_QG:3gdFnPI=;0l2BZH8Z^4N
J49Zff0Do0BYN07_@bRedo0JW9G^Rl@6oO0=LP68SUQ99ZW2^i[L@NJ@NN@YlQ;N
[dRhG:E@49BLdU8VbTKED/gD8ZZCNYoZY:?YA7XB?H<nQ?LKm0OdMOXj`c9ja/RD
<A=Q4k>8fHGgGZJKjF7NI_?HLF`e>hg]I3N`VnQIk3_/1k;E//fb7]UUfMoA;5Ib
RkU=:9fcZ;>_XRkolf9876:O2Cn2FJBH=<=fU<HNdPAMZ5fcbG[TEa_4Qa[XeG@I
UHkJl0[l6;Ee5jb23OA<f1?jT3h0ie5C5^:DWK2?:@8k^`>Ulb2TXaH=g[j4a8Ah
[lLMihXEW6SbKM5FRmTDICCXMEY=Q4ZYT?>LS6EXRT1bRJ^ddNWg=?XISj^l?4F4
GDgHd7A;@b=^IJNoM?PH_e=l[PVkQXgdhLPi8dKj`R=m@b>9aUT01BW9cQ:GdonK
HYLc@6I<ZL?j`lF^NZNoGjYGBOE7YGX4ePD17g2FV5^;WGkBj2caUgJdMYDd5ZLT
TchO/T>ATR`J3QlXaHWm<:5Y5AYHV22>:?5KGLDUOX/;jmQ7^d^JI_/WCjT[:HhF
Q7Y/`jJJ>U`S9GVN7o64SJ[I[]TK0ciXKQA[CC?[o7AC_ImZ5>OB9_U=[V:oJNGW
iWn2=f/UVfkYm5?^dZJF[U:o[g4S<UL46dFXJA=25KE>W9IJFeoW9f/7TA1aW8nH
R^R6OH:kLKkC;gLE^EZkiSLRLj6V[/OZ/d[6e`nCjgX/?X/4Y2CgVEOW2dQmGl[h
U?5RVBnHEhO;;al:]kmkDRc=ZdmoRVE5cA03R<P1edC4dnnL9BgR@VAcaJ`U5kYV
iB:Ol:XWB>Hla6N2Wd:MXMeneSfabMmINa>=e^8`LXgcRg_T5Z_TQ8[ZLGaSUfH<
BP[7Jec>[ZoAFcNjn_lj_:EY/4GVeW`=HZLXj25MlI>VVoD>dEVjTNYF/j]EU6n7
95>4GNJBFaX@5UTSh^`gX0>OG2OhWOGHP=5TLTD0i9?[3Q>b^Ci0@V/3D6c_`aRE
_^M^k4hFEFeN<Jj?@4Xb=R@:F4]=MYKRbZFR[SRkW5dCIgLiBif]Z4b<FbZaXjF[
?PdiF5^7O8:Y^::_?WZXfU9O?`KWBA?W`DM`N5LmcS1oL0H/YJJd0AbDWXc>U?I<
[Y]Binl/S_KkR^]A2ZRn9bOGnDnRi]KGhjR<8D`AheGcc8<hIb;>6HWHWaFN1F>G
CYbR_Z];W;>fcRGhCgIeAGN9nbd<1`R<K?0==PA072:b?40j9n>cF;R4J4T6PT]0
]>Y5WXi2UKjYDARcOcn7LhK`aRM78kHi4XMcOb0>imd>QlOL5XOcQc0Ma^42a3UO
i?3Hoab7a`gSL>7gLmPgQ3LR>AjamDTL;_Z1>3cQMSQLO5/L;QW2M1R7Ba7W4Y73
IOli3YL?ho34knO`Y26l4LT:a7JBa>7:7hS3EKO3hN[Kh_0M@iP>ho1Ta?T>TL=C
oW<L[QW6hM[_io3D8K`AbC/AfjTBQjOm@1bNOS/L[[/]3]L?HCZ<`c<@igZA`gL=
LMPGkHMKkG3W2;<;?kQQWWT;bc5BHWE@A>GQ^o<jN99i7VHbmh8?hH]RWId6SLa5
4;2]1U<7_WCWHiV;ZAcC6]T1F8=U?WD0=V2O>8l9gmed>>g=lb0E_ZFlQ;0Cj/CG
le/^J[1>gm86n?Hfo68UD3JllG/Q3]lF_^^BP`;OQeAhbR=NjZ5QTES3/`Bl]8Rm
GZXIY3`7LQ3cCLB<4OY2:YNJ@jOC^aPK/ij]HInAaLRfbckVG/K3SYO`IJ88dCn7
kkDdWXm=29mIlFT1H33aVP30>D`RS7GjHjaSbF59HbWo6;W4hH[CT/BIF2cC<k:d
P]J;ZHSI7;SaAoK4]@T1Y^XjWX4P9inTUi0JJBf?CdomS0KFI;920VeQf5N5hnEh
7U5mYFZP^ZBUn0/X[>[?B2NdRbHe@[_0WQSXYB[5>FHR_X/I8g9T]<m6[f@Y9jmL
ZE14h4bbUHcLBB]FPTEEF6=>Z]ILZKYB<51`iNJ44Y2A[/lF]8RUDM2j]3=9kd7B
6j`lB8ifTf?1RMg1BNBXQ:/?ehUQO`Ja/=MGWL>D<]?I1OHOaJb<FD?FDG`R?l>b
`7:oiGkKRaHFHTTTHe=K1<iV`G<deQ4I6J]GI>]IYf>I4:/BO/;UARf>EG/S7g3T
a/JE^C@MYlg_mEoYegcMO`T:4L?2OZd^;deWbR=Hj_;b]9Q1@dKjQ1Dn6f=A^KDN
YDhM3g835dl/C8A64Dmh8fIhXZSA4?40h`5Xb=4ETYcA>MVS?:iHC/Ji/2iTjX`6
CQI9I=R014mJnn[91dKEK5oEEnIQS]55bdSleH/[BUoLd9`kfdZ[KbCd4EgKhX[/
fPF[]VjZF7^lhec`j[??[ba[ZLc9V3ko0?:5PX/XQ5i6T?@UdfMU4cTj4FBL@Xh2
H<U/1RblO;J`o?j`<96h@NjS?3DXDGfFdJG5M?4M_1SQ`/1F?40Aiid9Wc2;jAaY
GZo?B9c`6lhYHl0ZibRLLZHPRQCeXd1c]@3BZ_X71U0mS4:fV9S5eo/IoOEn>ZNk
>eQkl:0hGf?XONHZncVThG]Ud7Mg@ZCGiO7TZ;>5<TncIjGj_SSi0]j/=[VYNWF[
nT0/[E2?RHf;EM2<cOaC@eYJTVf<PFK69<WC:HFJelK5>^;CdkEV]fTRkhjgIS[L
fXWPC[=TI3h]c=l@YQDUFZfiFXF5:4a]GYjHX;2`_e1/d:2<CGVY0eT=BbC1E/FW
JQg0Dak:Tn:F^JdN>QVB82EE:]Q4?XWHmHhTR3JJThS5C5:H991kUDW4[BBYF>LB
<8_AfK0c2S?D154GTY:8YT2ZBSWZa@>X6BC:59FE:JZ6ei=6?5i?mZRh[4c6j<:Z
:eIV=9RR7>8HXh5a>KfNdHC4L:=VGF^KfE=AnLbIGdgIA7CG_b@CSTMVg7G1_f]6
o[Vg]TgI5?cIGh9ofkfKYZ[8QEGEScW7?Kdl:m>MTY`mlmS[`CmlgE5hkn?=2c>M
jFVanG=?GgUgdlJo<DYao`Zh[ljR3N1PU<m:I370D@`_:PmLYfPgbebGFOQ=Moo[
kRd/Z1XXT4B>faI5OSJXOC>XIDlL^_H?EWe8e24JJT8OBjLMTGR>E@2omnDVYQ>5
AQV]/WVcbSGci?<eG1j_DlWYj4`^CVkGZ>ciBEAZ@_jaO2Xo<m6]dg0/Ko?6VV`1
d^EcVN`>cV]?EE;fK6D1Ee1P<g09RMeaeW7A2KI9TMiLbmQa;i<MB50Of@k3E>3B
`6VDN5SdQOdXOE7d3KRgDo]CnlDm[SGUBDX@Wc?J60_4hRHiT@:HHj85R78J12;4
`VQ:0:_M9:1nHbK:Me2dHI4fa4TR7D_DA=[NaV5kOac9bTAiJPdh29M@4eN/en<E
2iAmcVPmDBn]_ZMn^m2J^JPiXiKdSS>Z7U[iL;jPj6KokmTC7L]<KUF<=S7Idi0H
9Aome_gKC[bdXn_]6LTCmfhafVCZ25_JG;:@CcJWc:b]C:amOGMinLj17KIHVUj[
TQFiO>GcGebokCTm^BC^`hk@9hbK?HDn:PKJO:Uk^GfflcHjUXn<XM1=V^`/YeG4
f9E:PiNg>ZfYVUBB05Z;`kU>>=4@g_1E0iL^BA/;L2_QCh_fDN:NFALUDdC931jR
Df1Vi4`NXYO7N91IJ1A5cMMWJDEFj;@6B^:0dADG=Y2BdVMe7<Yo[_6=KjmNF3Te
<fl_=FO;UXMog>LY>lFN6_Q;eIAPOo1:<>S?MeE]F?GE:o/o>O[>S[/?BkH:CoSX
Ld`eF24Jm_WBmUW8CW<gOl1<Cn:e^`ddKI3I[Eb4gJ2<iZ:SCAZ_S]1NBV^e:k`V
R`doNg17Q:F[1SD6:B^Xj/o;4fg4;LI28W0D6U>gbZS`P5Z_@BZeTA[>PQ0;]408
aM3:Z0P?A>X`Ti]U7/8@VB2i0e@Ed@j4Lm4iT0J8<[UBD@4h95gBRRaA7JQ/3FAa
e0LGCHLdBeLo?bUmoF=]3eT>aOcmn;_GR>hm6e?]?co[XNi5CnoiN<=mkkm6/[k0
hlTa;<Xe=gB1kTNi:_7/kSiOiVQeVGZjNQnc?iYel`HZdZh1gVkWm0[:KU:bZOYD
CH9FIgDX_EI;S6>M/;CXE_9A`2=UJcGKi0XPa:a4fVbHPHGbP2:Jmb21TWBA:Ye8
R>C`I4H`AIW@[K^bAK8PNi@^jnYSNeK]fK]boGkBEI/nmXEW2YmOO2AhkO8Wi9j_
cYommJo>_DV=7QEC@MV_SM/fZhjTG?/cVHhfY3adPK7RRJT=CmOMA>EK/H=o`[[?
@K=Z:Y8e6=FjB:?1Yo8In0@[ZE0NYLn@enTcdAob7lToL7cXn/[dUD]iAW]6AlgT
FB4^LUND?Bi?aW5AP]g6:NaABSNg`kK?MPcg0>>>RWCKF8]2aFTa=[1kFJ/g;YGc
FR`Nkg_2g[3bXni;Z_oNP1@GH6b0J]8`Y2OXGTFo4]h>YN1RF1Z?X`W;b1`N[DJW
dF/<6TJVL/M6agT`V[EkB8aMK^8lX3BZ?BA2kK8:f<ARaY]A[c2b@4J;oT>b=I8[
BDa:O80/JH0U3J8:REi2R<4]=CYW=2X@QQDbi;HFUDSd:nQ<>4;eOY2KXm?L^<`n
^^?QZNV6`m`M6CD[a]Nl4O`c<OnA>9CaTejh_i/U;ZI/`IeC5Tiji]WG6W;:l[NT
C[IYR0_?i2UB5?@/:gg`B1LA?oZRceR3aUgD]BRXmBDS=gTCIn:mS5NoS5_6loX8
BVo48=P^hh`ZADB2`VXVaPB8/YS<n9GdR=0LeSGAO`bJ4@bhd8[T4I5aTY70F2U/
<5eJm96RCmBje_Cj/ZHon:OJU;jHS7E]Ag_A:7`lALQk]_jYPBWD/afSjgIm<?36
47hb=e<67US[bnMhCRf;=?4V]BWBbg]A]>FFJLZiBYG;[K3JGAH5aISLP]eTSi1a
88^f^FVm8QkmWcH1?b2B7V^2n=gDQkZOjTk`P<DK7b0A]a9aBG>Uol[=8=UDD8R>
/En:;L;1HiPRhb15YY^N00TKY>/F2W]lXnZGM5HWaaDldo9QMN;a1EGcWcQVCFRK
/jnGBM]iAmcH`[SBJKE?C]dl<9[jJ/7TcG/7]U375fEF??FfB3T=nJ6?607]X0Zo
3EWPDEoFCWjkiXVXGc3Mo5k=oZP0o`IoW_ULoBN3JP`_/i/iUEfW]70FRi7bAUZS
iEjSaAXM87:dQX?J7PjPQRbQI0BC`LAhU7XiJZJFlQ3>Q3Df0V/:PlX3A8<I7hG6
SeIS9^V^V8U6;dhWASaBQ1>EYD<]YM2_QPgNYf_C:eojaOK]cn87^1_1oo]ml0KA
OBU[9i5k]momn8fNPiOX2l6oX_TO2?jB9=e09n]SD@lgX4=k3>F/QC]l7Ro]RAQ=
Uc6<V]M@J[UF[_;b;4YDZn2]NR;J>k3Xm05BP/9K?NC9ZSGhJU=HEGQjh3C^FbWP
7iBH::TXTe6ddJ;jKCQXO6h1JkI[XSG[7d=am>G/Y^QGJ>[@dX6MXUl]2YfWSc8E
n?D`SJCj7/VEkfBgjih`k3C^C9C5akVm>D:YD1IGiYdF=mdk9fj^IhEZAL@:MHN[
?JkMgNkI6m>M[:OA3;0YC:XN[<IXTle/C36TaTLZio4NMhjKL/M6:9PT_OUeVeg?
<OKDGDW:=4j^eU0LY0UYEXLib^`eSH_gL=ihJhKJhMF<0fnZ9CfSIlQfXI[VRC]^
84n3=I7L_3@an0U7aAPFBfXK3XL[B@[U<F8H;:PM0/Sa/cc1B5P0O;l@R5f7KM46
/d2LTK422;7Z2=j[48S7;EMPI2cPOc4`Rm7J134J3TM;HNLWND19:fhZ1KY2_A@?
gaX>Bk^OnmMhF8H1TiMLi]g5gK=gS_GNnlR6lNfojo_7PPWD0MHckXTild[RZnlk
ECC_Xdl^Wn78<C9iA_[djGNEa:7ESdfLn<3>UcO?J1fKFEK]:dfdj>eYbBF??g;^
XjNYKe6GC:7;U9bMPC^Wi/F8E<E9=@V@@YnKRLXcdC:e@V]5Th1O:1?0Z3I6dPjJ
XVm4FBcF6l;L`LQQX27_M9[X0<8_F6VR8APXj=L<G1;O//Ag;2d6mT?aWbLKOF=F
mm631cg6S8PHPf>2MoF<;E_H6L7g]`jDi>ZEQ=X/ianHBkffEK:iN1k2kV7Bl0l^
C]oZ<^J07;]9:CMA^Hk^h]LZgZA>djmcIoWG5FNEbSWLO;i5<DoI`JgP>a@[U6^i
;ZE274^EdOO1LYJN7QlESejKbBOic2?T4DHVI`R]Y6QFYV91aR^D=:M@8l4L:m_=
dlaY1BDo[@BbFfF9V8]kah:_lVIDXkbQWdDRfPb5J01=1F9dGC5UQDo59^S@8d62
CZEB/^/dBOS3Obkdb_5kXB90=_[d>PbK>1W3RP=UW9bG:gRaGJeS<9QBXERTAlVj
ZUAlM]EY<k/^eIc4[m:l9UGF[M:L7V[1Mi669D^FX6><Y[:RBAIa:M5mWGo[WCOO
oEe_l>ca2klm7_`eTgJSUjjldDNGGGn77W_SElQ@g;_B5F[1Km_okT9OQ[IEPBLm
AXb]W7RF<aZ:X@A:YJoV5OS=G_`^?PfV```LBO3/QdSCb<CCX:;b2A?;9bBE]bc/
J6VO=j]96R5eHhIW9m2:JCVVmIS@T>2o4P3oNh3okL;d8JJ_<7f3do:Hc9SR<NER
:/MDQjTEdg9<jc7]30eNn0`<e@WR?1cfSX2CA/2I8n0a8n2a8n3J4O3D4K18mJgh
=8n0Ihf0Ihn09KWL@PoB?6`njCm_]o@_7]6oM0Alk`QHn/oJ;LoO9oKo?h9d@Vh:
IFiTLgAbIF5]2VE^I6mRJPXa=20`86mRJPXf=C<e2VE^I6mRJPXa=B0`86mRJPXX
KF5SCe<PEVEbLfU_KR0a<2ha=2hf85`X@WEYK6@P<CQ7>3ML:B1AMF5bM7XPD4A6
@fm^M6EhM2T:IFiTKf9Z2S4f830PKf9Z2RQ4>S8`<CT`>34g<CDd=c8fFS0`9c0`
9bT:IFiTKf9Z2S4P<21_HVX:?3`P;e1bKfAeHfEb834e830PDR0_@g9UHGAYKfi4
HGAU834f830PDR0_CFmTA65dIB0a=R0`858P?Sh:IFiTKf9Z2WQbIFH:<20a=`X`
<30`<30`<30`83He=C<e86HP2S0`<30`<C4d>38P<30`<30PKR0:<30`<30`<3Tg
>20`<30`<21^80X`<30`<30c>C@i830`<30`86hP2S0`<30`<30`<S8P<30`<30P
KR0:<30`<30`<3Te>B0`<30`<21^80X`<30`<30a<3Pb830`<30`86hP2S0`<30`
<3<i<C@P<30`<30PKR0:<30`<30`=30h<R0`<30`<21^80X`<30`<30a<CLi830`
<30`86hP2S0`<30`<3<h>C<P<30`<30PKR0:<30`<30`=30c<R0`<30`<21^80X`
<30`<30d=3Hi830`<30`86hP2S0`<30`<3@g<CTP<30`<30PKR0:<30`<30a<C<d
=B0`<30`<21^80X`<30`<34a<cHf830`<30`86hP2S0`<30`<C4d=30P<30`<30P
KR0:M79QJFaULPXl?20_DfUjIB0a=b0_DVm_M20a<B0`858P;dU^IVlP<B0`858P
;dU485/P?30b>6Ha>F4cI3L`=CHdI34iIFDiHFDh<CMRHFEQ>3AV?PXl<38hIS4i
HC=T=c0e=SAT<CUUICUQICPa=f9QIF4h=6Hn85dP?Sh:LgAQLWAhLVEV2S4a=CDg
2RDUADm62P\>"], "Graphics",
  ImageSize->{280, 329},
  ImageMargins->0,
  ImageRegion->{{0., 1.}, {0., 1.}},ExpressionUUID->
  "12632537-1d4b-4a6e-a880-892d5226f9ef"],
 "       ",
 Cell[GraphicsData["PDF", "\<\
9E14ARda;S<:9LCUl^G[Yo>Pd<C62S@P<21_HVX:?3`P;daUKVMdJ20e830PDR0_
AVU/M6Eb82m6K65dIDAUHfmTIB0n?PYcM79UHFd:N06=Ed]_73L<_^]Gl=IM557d
e/`QQlKX9KO0Rej:7]YYSB3`5S3LXWno7jW7J>bI]I5PEYChnRRBXYoX:cfAYoo8
dQMbm9dngSeK^[/W8oo^kg1/IOV1OgbNJKVB=CZBRaUO4=5Z?`MEj4Nj5idk@XF_
b`GS^iIm:@EC8mNEW4gJQRW@?>^HW;5D9<G[iKUjoKad[bfi>D=/HUfO;fB3l=BO
biDnGRhF22l?M?[cC9O_m??U`?mVFgGK`2jAT<lF0WC6A=i?7:hS^j[HGFkK7FaL
:AW]L/a@kh>><EClCe35=fH9Afi>]jaF];lOFnEH_C:d^OFGH=e<MWIkE]DfaWlL
FiG4F^<9NchR@Fbbn<:PhUA]<2d/^]W/FJB]aKn>;C;>d@RXCHjnA6TS8YafPo/2
i/>aDH6iZIm3V9^B6kR>jj05Z4Vn[Z0AkaIOTa47=mIJ;ZQ]dQU]S;4VCMHkH/;V
6?8dHCg?Tk<Qdd7o2<iYKjfBfdJ=QlcTN]E31EX:dI5c^e5O[eYa0Omc>nYK<c2K
_7HVXV2TTmEXm4Zb=W8eeOX5:Zj_l[?9/5oYm<^I/]NICRRZ3jQ@>_eM5^Y4IhY1
cgCjjMmfQQXXC4S=/WQ/Rao>29jUdc?4A<mmUkZNeFmdnK;]Cm`74XEgN<V^mNjf
HXBdkJ4maWPJjQI9@?R?HPTC5^Za;3aZE8ihlHdNaV95gKSlIRCEjLO1akGDDg`O
`[F?ZUH7W5?L@]jd_NWn=_V:<6L5Z02F<iXi;oQX1b7NaKL@BXYnfTDhQoLQK;e/
f`[Ak]n5L6Q:g:cU3Ye91B4F5B4O=HAF^bS30@99N5I_C`Da3X<0=e>QDEjccVJ6
R^Qe<VPFCWYjKkI2;DRSFM/Y89;UV;^2c1E=_6cDLVEnH@0M=Mh2?45M0@cQfW/c
I`[leC`VUG;Lg6_RgElNK1HTlNNQ4Hg]<HGb2_N6R?NbKW51jYblYN@d9YD9Un<W
NJYK6ndK2lE9ViARKU/ZY_jnEcG3CWWa8KDbXHl6U>6P1dl;aX9V2ajFSFGdYo:/
;ULe0hQVJcl8o:hhQeJeVLF6?F^/cQTm7J>GmS4S2Sc^9Mam6n7ZQUZ`iOG/Ico`
^:9jD5=gn_35HVd?NA3MU5EG=6=bT?6`Fn/k;5MMjW/[U:kY5KQKnF0]`UFVHZAm
8IcTO50FGYK/5ihbh?0B2FVVU[PRW_QKiG0X94l:c0U22ON43]@5QDEDlPYlcEPi
H3>[d>[TX_J_EIin5^ZcOB5J0CKOJX6bKk;47EHc^70YG[KOjkh@YJS:^UKL:U@Z
4PY[L@9:=eK>RRN]E5LWKmb;2XJ==S2=ZVR2RNERR/Oe3hgJR`;bEgY:>OBLMW2]
RPYImBkDZ>[K:RZ>]cmPBPmZAR_<iU8GGOfmP@_M0^jPjO=TO4F95`XCR7AIWn/R
bOaLAcUN8jXN<hodbW[8:_2XR@@d5I:oc2/D@1N9;R[SDQdTILflcFPmi7SIEGCe
]n7jnSn<2^Eb2VE^I7=dLVEQK@YUKVA_HVX:=B0`86mRJPXa<C<a2VE^I6mRJPXb
830PKf9Z2S`l82mDNG1U82m@HFMU82m@HG9UKW@P<b0`858P;e9ULfmeLV=ULb0f
830PDR0_@fm^M6E^M7<P=20`858P;deUI6UQ@Vmh85/`830P=3Lc83<g>Ed:?Sh:
IFiTKf9Z2SHP<21_HVX:?3`P;e1bKf=CIG@PFb0_D4A682mDIGQd85dP;d=_K6mb
Dg1QHfDP?3`P;d=c<B0g830PDR0n?R0_AVm^M20l?20_E5@a83PP<21B2Shn83hn
2VE^I6mRJPXi830PKf9Z2S`l82m<IFiWM6PP<C0P<21B82m>83<P;d5/M6EbKV5d
IB0_A6EfJF=UDTM282m6JFadIG8P;dI/HGAUA6ESKfAU83hn2W=dLVEQK@Yh0IfF
MeACfAJ7ckdg_M0B8R0Um1Yj2B3B>dPE1569BH1@0XJ49WI41DHD4BUFI5C00DN7
8V=550^3PV;G2O8@D<K1DDA5iMf<J`W_[CGcgY[maeWOfNNgemUWkggG^P1@o884
`WAH0H0dXEPDk^_1G18CblCg0QP@0@iH0L3QIVH4AoQ40]Cl_CfIVJQ8a[?fkRj0
I;_K;;m@9W?FognA8SM390H02TGE=San9QOU0YAC/lDI<_l4b_BE:C:6<C8FX@VR
[2;Sa:m/mZOV:k_9V9LVi:4JFLhI_3BNS;]@gYXUhJ><1:5LV2GPIj=l1fFmE4VJ
0>Gg:=?Cn9a<030DVEo<ibJQK8TbAA@IkXWb0P08U<@i_78>RoTiJ9h0N:IWi8X4
RDURYQ7GV6WUj<QVn_6cDoUR<B^D`dgQR7Q<coBd38h`5h2_KiI50BEIKIUXTNf]
7>g]FMKVJ?VofMlNOU?m?LQjneGa9^c?WT6<WUWOK>b/;kdF0?HTFY/M/kjEE@2d
K@I0iN6/CnlP0?850;CNW?<NQVaNT/CR32L;Rnc/K7<1Wf/^:nPgnin2KlZoQSWg
VL_^neHkYQLoPB=95C=UANFVYjI;A<c<30jGcfCmma3ohl0iJLg9`bbLWl0GlHGX
EE7XU0V4RFRkQCb1F90^I0Z4OmGQOaPf9`LIOYe[56QeG`1mQCU@^4T7b6lm04<S
0bA^?gX2ON]K434:b;jlJ:fA[g>?<W[nioXO2eb:K^5<@B9Ci_H<SfAb9J8/6J?O
Q6c10Q:@1gBP2SB1;S02;60=780cL0?N8024P4P@0iH3;TP2JD04/T4nf00:@C7H
0GJ3JW00e85jd0A>PSI`1U`4El0=L0/<P4M02XK1Bc01gX5Y28;`41FR@JZ@5Z@?
VD;F41]J27U3@E0h50?5@hV@4990nM0VZ1PZPjZQ@e0mm2=d6[X8GH?jX0O@83@6
o@5mQ16H0]=Q3MP0]X3I/3/L24O2bn14N1FL1aO0fn5:^1Hn3[O25n4Kl00/QEo2
T`Q0b0P3dDIH21_aA4:@F2@14B5[TB:T0ZU5VY0>Y1^iSDRALN@31XNQHIPH5/HI
hhMIS>5REV7FHTX`eIQSV5I<5nHfIQ0cPOV2YF;E/JIH9j`oMPTf4I^=;LAFH8mP
Fk2G/@?HHN`k70k7`1WR771n^1QL<Vhe[PBg3mN<^h3[``gQ9_5h_2[N5>n23l5c
l69l8Kh:Oaao7]n?7lJo9i09FPA[PPlQUR0TK2AD41X8i`SmQ172=561Z4md8XH@
NLALHRVaS]Q1_4TL9TjC54V691MB92VI]85DBFXRGBHm9[dQTlTjI4Mb65U0GTn^
99lPGbD?TSm@U2PV54m:74E2fDhiB[U0ND1i@jEB3JQ^e5RZV;ZMFTnmA7e:OBm7
Tc>GliOSbJfCZi5[UN^GNbE?U=NGMiMO;YlWGb5oB_jVo;P2DL50`E>1Xk1FXDKQ
]<8mQDU5VZ:EHXQRVV:9HX?R=LEA9KbBPI:g4TnY@>V`dRFU8AY2djEid[RdCK@j
fVGJ<1e7=jCkdi?YaO@Oj;gd2FDUIE_U:>DLiA[U/lYB1/8`H?PcDQVUS9><^hb?
lcCV^LoScm/f[fUNok`YUOTZKRYlUB:EIYD1UHnZC5E_eACEWJY]ZToD<6XVJV5Z
fF[keBj[SLnWcgNNcieO=?oTo8OZ/;Z9N[SjJ_G3jSgZTaZJ6[hJ6AYE6YLdaSDI
VVjJbI[UV^LdakAXFP^e15[UF^NeGS2EVNk<E6HU/h/iXJf^kJL]dCjTgJ/m[F>X
/eQWXdjccQ=MTRiK=d6gG;MCMd9?BbmH;en_DNnQ?U6O[InT_dNoFgo:`=0PfV2;
@I_1Z:6:XKmQWV6ShF<SZY6[dBZSFZ<kaSQS]W6:lCkSFbJ`RIe9TTV=bDeCf=CN
E62jckC?36_VJ2HdZcFkaj:`g5UI[4KFX3W3?<QlXgVKnB/;?H]HRidFgAIO;>d/
Dbg[;1mI:ET5F6fdj[3j`m[4VV]MHgg7QV[SHk?>Y]gV]JfY;Mmf_nem>iYM/=dF
^djkcoH>mR;k9_/a1cf7N8Nm3_OHM7HX^hAmeA7[j>6hc_6<h`LWNbNaddVWgieI
cRW>3LjS2``Gl1OD;AQbdG7Q^1abTBiT;XaON72Qe5GKUN=Jjo[<CMN=igK4KLCM
f3gIoKSk:`m;3i57RlNDYi?W6/l;GXRG[eNAEjngT_MRkf[_Ychj?XTnSChC_WJn
Zgd_n67m0_efn]gceo3Wn]OkC`@h1:`9j0ZT14H4EPLn2c894PEe1<?10L6kPQl_
dUlTG=@F0T;l@gJ5?0Te35dEnW<H;R`d[2K/NKQEN7ihM`@]HTE4@lBkB8o8d/Q7
RhdFBaIgA/U7aDGEAde5NdFGAD^GF2aI/nA6S5Z<8:Hm5QlK5G/TMW:Ymm;MBhOS
k>8:hnh^<ebF/ncJL[GUZL_?[Y1O`EUa:QhK7agO4?n94l:YiDb^m5niMnD4ei>k
Qo^BilH[ihgaGOQUo944UhBbQ=54UlAMRF=9[TTEBN<2Cd6eh7FbGo:1i:VDT9BS
:C>YdJW=JHBdn;CC@REQR[0[GC<m9kd_`cBS<4>jbVWEkUDCXT3ATD`XLeUV^iR>
oTceB8`TVbF3F@^cJ[;NIdMUWlYAc17Vm>BJi6k;7LWcbO]n=FHeMgEW_WKnQ_c1
=Ni[3Zf5eZiLfkU>Meg1^^7e_^^?KB1]B=W`bdK;SFDKgfj:g]AAX56`_V1X/noV
aT:i@U7Q_Bg>F`i/aF`EK>gMI[>]J]^G8UkAmF;;hX[RCbGLT^_OFGeGnMg<mXC]
_JGfYO]gh7H8MmcMjK[cF9URFEkId:kPGJgUc?:Rl[NkEnbnEV5KLF0?JHmTSk@b
Z;:mBZmZAmFWjZCZPAZ?V^JmjW^gkIgJam_G_mm]Om<1S@?51chN51blOlSgD6^]
@Fg5HMcQ[<??jj;Z^[mWOemoA>e8lI7?AhE7YLO2SgGE>mCG=jPgU3K2SI;6/N=a
afomh?E3Na>[jE0cXkWh13PQ>O7RaoPOkih<?=UiRWfZjBOmWoJfd5Z:FZ7Fg=J9
]Z@fJG]<NmoYP=>M7LhM;CnKogcdS?JIV[?:Id_?TLhEW9/iWgMnlT;6QO6;RAN7
>UMd?[Zdi=:M[[2^g/^1UjmNlKUbZM^mnoaEUj]W[SUM>gfMOKg]Q_f=eQjkWYIO
k7iYjKG_KKgYL;?mU^>]S[h5ONOjGO/_g_JjONF>oidK0h/6n^h^_W_oG]`mjGgN
oM47Z@mN?laj>?eXoF?/hj8W2TlZWZXo[OgEn=MVZKgdk:3GH<ncR6N?Q[Q3;onE
nJm?``G?ZLl[A[A6jTN]Aln<nHcMN[7daO3;S9OChhFo:OjfmiGAZimnMo^mIf;9
a?1[dN^I?d[NZ;hin]KfKNMTj>CCMfW_YZN:gZ^n?oJ1oJ7kHoC7TNW/CoQ?UIn=
?gMl2OcbN2I]I^KOmhCcn`YUKVAcM79UHFd:IFiTKf9Z2S4`830PKf9Z2S8f<C8:
IFiTKf9Z2SLP<21_HVX:Fb0_BD=3@V5cIF@P>B0`858PG@YUKVA_HVX:<b0`86mR
JPXl?20_E7U`IB0_D65WIG<P;deUI6UQ@Vmh85/`830P=3Lc83<g>EdP;d=_MFid
834P;d]YI7<PFb0b830PDR1M83hn2VE^I6mRJPXa<B0`86mRJPXl?20_E7U`IB0_
@f5dHFa_Ib0_D65WIG<P<b0`858P?Sh:IFiTKf9Z2SPP<21_HVX:?3`P;eAiL6DP
;dI_KW@P;e=eHWAiL6DP;eAbMFEDNG1U82m2HG=UAVm^M20_AeMG@eE@:dQUK7IU
M6USHB0_AVm^M4AULf=bJG1dKg8:<C8P<21B82m5KV=_I6U^Ib0_CF5SDVm]HFi5
KV=_I6U^Ib0_AVUbLgA3J65b83<b82m<HG=d@fQQLR0a<CLP;eMYI7AXLb1K838g
>0X`830P<20`830P<20a>C4P<20`830P=CPd830P<20`830P<20`830P<20`830P
<20`830P<20`830P<20e>3@P<20`830P=SHg2S0P<20`830P<20`830P<20`830P
<20`830P<20`830P<20f=SLP<20`83Hf=b0`830P<20`830P<20`830P<20`83De
=R0e=CH:=C0`83De=R0e=CHP<SLh830P<20`830P<20b<S8P>3<c83De=R0`830P
<20`83D`<20b=cPP=CDf85dP?Sh:IFiTKf9Z2S4b830PKf9Z2S`l82mDNG1U82m6
KfidA6EcHg9YL7A_LR0_AVm^M4iQKFDP;dMGEd=ED2]8IFafIGAYHf4P;dI/HFMc
83<b82m6Kfid@T9_N21K;CTe<B0]=3Pa834d=3DP<C4b<Ud:;dUdHFaYHd5^IfaU
830P;d5cHfE^M20g=c0P;dAULf=UKW@P;C8c<20_@f5`B6EYIfQd83La=b0_DgAU
KEHP>CPP;eQ8IFUWJ7@:=C8c82mCM6E]B20h=B0_@GIWEfUTM6PP=3@a82m=HGQG
JFAdJ20a=C0`82m6KfidAVU/IC8P<C<P<21B83hn2VE^I6mRJPXa<b0`86mRJPXl
?20_C6E^IgAX834d830PDR0_C6E^IgAX<B0i=cTf82m6JFadIG8P;dI/HGAUA6ES
KfAU83hn2W=dLVEQK@Yh0KdjJgQCEKI[WgNB=TgBY7TdJI;VeCAm_fQYXHOBU_9X
;Be2RaCK@Z4P30m[5FKPEXD1:Z:8?1@7AKe@@8M@>Q14_<RPj9dIALLWhmEaA<Lk
<agVgX_N4DQcecUYJm/kn_73Klk9fW^]_OOINnfeeei[WGgB/OZ^=XR5;Z2QMVk;
bTDPGnhP07Ud`O:FUE4jW/7lo8;>3TNDIU<0j6F;ERiN7ZF5A`6D]/G;eP`n7glE
@3>S_JeUHK@NKV1Nd8h5DI[THNi^GmiaCiCFmF5N^fc5P/7jn=N@CUgNL/oPn?0A
dXhO]Ba_RkIgKlGL_G;5WAf3]8SiS9F[f`KKT`KTkddPF:Z7Ad01M`0?56S`KP;P
_eCJP<5JZAj_V^hGmmdNEo8EJ0FI_[gj8CUooiFNnokNM/>WfRilP`F:XOIBc_T7
o00a1>_kEM^7JnCW<=67X3h@PZT8Y@Si287091=dT@?`<<9C23@/8@o06X@]28lQ
<<?H8JA>T@Mj6D5lPJ`12iTVZQSk;;gIKU:Zk6n72=NgcojQjK?Ca8b[mbTamlJ2
HY:B?4FNQ8EP9ol:7[8FZR25?7kL_lcNS5F7H2E25`8]Yh@LjTg:/Km4d/3347c6
2dT<>F7oHgJjoO?/44EjkNMl8@JcUi>@4^?/Ifgkk?mVFfao2N58]>Z`7e^L/1nb
;K?_B0ZAag_]SmQ219oI7/g^/^6S9nc;oK_/2k?UnQVk@]BAGW/Ae/lFEOJ2@ZLm
ggKIW^T;2@CYM=/<Nf[fKna^O12K>K1CSjReFfdkk>>a:/UFhA^?L9XL9W/QUNc]
mDbc_h0XC_OhE7oQ[Q3ilO6ZU6a?R:`E2jYBM_V[O1ko3;_7GnWc8Ckk=Gh3Oa/o
RLoQ0g`:knFMO2:_5gB2AU0;<H9B40@nA9k[;KEcYlTA:4Fa73T^L08K8So7@^Hd
NEh^O?jT`0RD088n5?Tm:Ro15BM7nS@BQ/P9C/Jh47WnN;CXNM6>NhP08eMX:0W7
15>PR431=0RB1d<LK4cX;3FEjRIZRb[;_b]YUV^6d/1gGbIR2njJG]l@?6a[3>I8
B<CF>=CL=8AlImia5eJeU@D2dn_F7>mL^GAAAI^[X]UEdHK@77bP/mdDk6Ye>8h]
GBUE>8:d]kUe@K^D]k@5Ek[JbX=;GNF>HigbLf>Z5dWEWJkbHk2XHUK3/DERFgU_
YmQIhFXYKccNF[JjJMAHFhK7FUgf3lHZTcYK;HgE:SlgIZ`VZKYE6Z]96Z]96Z]E
K9G7TRIO/JBnk<h>e4i7aI;YSV1:OG3Zc;T=@DM;HgV87<32l[^0?@/JmPbT/5eP
HC;13Q3i4>6BU0oL6_V2_@2JPNFAoj:;LE5?BD0=U9K0FGP@m/9Ah:07lABH3g_P
MK8DmoHlj8?gB19TX>eU80@ch=LT4WT;5/6cf;h3c/5>>0Han<ab<63]=^:9[4EJ
A;`E=TBN1SLD`ToQ31AQ[m^P?g8XLQa[jn1F>0a7l?UO4AMeS8V?o3ab6@BHRGe^
`9Zg8S<RAd47JE06]ERj0EhR7_YBY1e<D8cL?@5?`Wih6Oi2kR=mTOI8InARi5=D
EA=HXAk_MJB?O4XOIGhJNB;bYlP0BR85DW7DI]P1cf3oAo4nRjJeP]a1>/P>/Y<B
ZO^X?VHSJa`8Xacl<0G_:UP1Ve42Yn0lo3Ml@ji@9UY3Mm2_A?8So`<ZV8jcU6KB
1YehKl9k6lkY=>585YU<J/TjlRSIBGi;YE:gDPgDgM@me1Md3Cf?GT?oU[VCjFFg
/W/heL1GTM>A2i5g`@Pf^0eF`gZLgCVh25OQ6Z6a;b_aT69BA^KSgDGfDZO8OW::
ZREWbDGZ<?V4O4J^T>/DBlE@1RY0ME0kZ2?D>NX=NPVmTgj<oXCnRYW8D^anmW?>
`om^X7EPbl0KTN;8Yi6oXhTE`8T[D`HeL3^dh6aG@Qkl2lkRNKb?hZZMQeOPMOWn
S5RQ7oj>DP2R8aJB@j[a[R6gT4ET2MU7G/3k9IVG[bUL24Y1JBTSIJGZZEIZ>ME5
_D]edHUd:Sf=WT/OaO/enSgj>WfMHIUha/1<HJK2EVHilcSN1iPNYYMiTbeR9k8e
k6bfRmg2KZDG/6nakg7[^FeL;gN5na^JaAWl2Wh[[/k[Z;<_XbioNc74SMcW`8mP
0BTW[K0;Ef<oJH5^e:j5I3?:JbFTA9[XmO@D:P^ehBGh<F[[hk0>]]3cH7oT0oX`
_8nJ/Pbkk8:3C1WHf=fh>_M15V[Ah2gjDodY?Zo7kDYf>]3TFa<]IY<a`J2?efTe
/C4ZYD;P>IJQ:@9Y5Jk:ITO@faaT_:jZZWB9M[EP@L^8PVKLbXiPiNPf@HOdG0]F
SFXYH/]5HeZ:dIKRL4^RLIA0BGZJXl;U2?jVg>D8TKTc6a1o/=cEj0SfbgReS3l/
hk68>ighP:?2e5k^299VAdF`/[>m^j:i?3f=W19A7<[d=<U`R:2B>Pk2i9IeJ61Q
/]BR8VQaUEL4cBk4/HkfE;@/3=K>K:PXCg@j6k4<RnXJL8cd]2E1i1<NR5WXF_Q0
B8CFIPU[VML@Y5/JPeBce9Lf43BjbX?6]InK_RF7/8Z]8bZ3U:NbYJfk<RPf?h32
ULQVRF[IR]CdNPMfBfe/K0RBSH=<B3`^ADhUMZ<n`M>le15D^<YLkMe;Ve6hD=O@
Ja4]/_4=@Ve3[eTdbdAjfRWCnV8Wc_iDnZCdBE9Nk3B]SnIo_3mJo_II:CN]?omk
c:OG3@^0B19`CDDnPhh5lR0^I;I@B]X:XG]18LX9[dJ2deb2o4`>DZPc]2O8NZJf
1;_ZQmQX;hlbekbd_5MQ]/Q>Z:`AfcMgJlKSBV5kSL_AoAEjjfIGoem6Uk@<UW0N
cELPEDX;?J`[@M8bQ7M:c]:3/fhg^MZUmNfDeaAYUjURA07BTVPTWX=jM>2e3LjP
Xa4;<9Y<Vah2AFg3<D:f=HI8I6<8bVfW<4JUKin?eFVBZRdYao6AB4o3PU@WHQUY
STXL^E;B5DNgXg_Z`Vi7YJ<MUHWab3UF]7DgIZ84ja]@CS0;Aa@K4hOA]/K6lMQ?
Y]@??X;=^a^aQjF3?F0^5fF6/E5F6SYCfU_K<;<Qf5FN61C;6g4ED7g?eSH4cj;V
=SIRZnaQCY7SMD]<PccW8<oIZERO6nd5HiL^k::a^e_Z/kk1i@bNkNi>k9KfFi@>
4AQK80hFQ41Z8XTlA;YZlEW<G<i4N@fL;RNbeBS9=0mENTRS<6KoOPTG3?>=Chi3
KP]T2AOn@18^^QT9SklY2AL?LcY:`RG8Lk4Th@Wo?0U?72GQd^nG/3S<=c8i2KTE
I@VGoD0BWW`c4Rjo:@UG37<jB/:Eb7>59>4Yoc`9EhfBl=C_Uo2dHKjAbNW8kCAI
`S=n80UGghb4Jfi:`[L<LcY:`[G8lbfBQ6OnlbAL=d[2mMl_hEW3O2>C]b:g/f@9
coj193cWIRCLL5<BKQcVM9B4ib;?SI:4Ka^F/9PHQ95f^6^<fHDOg33?6b5bS9AH
7IAAAOS^_0VNH9j3NA:`/b49XATQSkTCjQ0jlHFk6?=2Q2Y/KbDGH0]g63HP_@7[
Y3j<R7MQUd=W@C7hQW82J@O<UUk=AecD84j?:?/^53^G;oJk6X`XifBL7e7b;BZP
?eORfe0<W_5lNjTQ3/naQRh]_/_5bd@15403H=a>A7aSFD[WdO/H1k<EhobWfO>L
b3g1ohCo]N35]QBnU`1c4MmWJC`GVa`mZa8b@l0P29X@`4D4RDJLoPQac7W<JL`E
7l4;n1C0k<0;f1>;NEIf[]JYmB6D<M]2=ok0W[Tf>LADGlNc3iCR4o@ZDRN?iAGS
ZIoA`1Z=5_3CIXImfGVj2/lQJZiFQf/Zf/ZoP=;Zo^`/@[]XD^O/L;9W`WgD3:V?
NLS_2/J0/QPWF^Ve;>D@E6^EbUS/RE_;:1bdLRfHHd[[C84JcMGZZbGQTZ]37LY4
MUIl_U>;G1ZLFYMf7^Tk@_X6IQ`Q9g[8bH6Y?@?CR;CZ58kc<K>2;Y3UhQ<=a06o
hAdL0aH5CiT5aCbW=0CbFj;i^P@bZo_3HFCGh<bGP5Ua_In9_mi?5oCd3=@O>H97
T924fSX1idk9jgQ9[:dR3JBMd9_YgL`NiB5UB15BLRU:0Sc74DY@:31A0/nB[HAV
77ZUdZ?3<Sg;NWCH@:ERJHFBhERRXPP=E18_Q4RSZ<1G8DjQY5VTNTAM[2@EMQoI
YcC7a>igKYf?79][[YZZ`f6c;9C:LQ>D6T]:Bj[3:2Q]DBWAjXZ:l:L]b]bD4ERW
VHhA6g<f<LRLKmbDHAX/X;60?]lH66bkBE=B`R?Po9^JX8VXB7`^LM5>fTGXKIod
KobD<UcJ6Ckmi:nYQjVie9K`gOB2Ji=9J:1:UTIci5gVJoIcb<Cg_P5a_So>io9j
2mCicRWNE^mJmMe^aAf2BFgdD8gZM_GQI5ZY7Yo/CUKBS=GdDgeVI/0jGTlch`>:
;4ZY5[C^I7]:EYKFi35>5C`YUQbkAc/E?9WVk9bWW4^gA1F/ofYoSNK[J/adAITj
;LhG0DY;nd^U0TfoEVL/bPSW=Zg:cYZlAZa>bM3J@J2lU3OM`gT/GSX=0Y2N8FM/
ZQ0P]WQk018=YP0aVdPj4`25CaDP7QG9@9cgHi:T/f9U0RIhmQ/8J3B10=6Db:RL
1P;ggW/_BRk1V92K<jhP?loWcBANWcLocifK`aQLR;ZB>H?NV62GfQSdS<_QlhhS
98W?Fg1]iKcNjC>N__3;VE^9k_XObNCCLMVgG@Xn?[OhhQ/kIfhMn=VO1ojjMbm=
EI=;jfXNLDaljYkL74mjF_jlTjl>O?9EInVMSkH^bg5TIBHG;ciomNf]3obEDDWk
3<oUf@9L8@hN4//O9TlABRBc29E0b3g/5hAJc;BcVaWJW49iM3C=P:BE;64YVT=]
I1U1@<eS:7XO2f@OInJgXNZILD>RjQDEhBnZOZQl9JQn^R:bZCXS82THWRn:<@AO
ifTlR2HDafhBeVW>bhVTG]2dJ]EZ1HGZAHR6723k?`UonM_`Ok9W[]^Hcji=AWKa
XZ4^lY5lfQ67iePUl1mRHFXFDFYDRC5FGfjEIXURZHH_4W@a2SXaQgL[K9XHFg60
b_0GWbbVRW=B?CX=c`YFGk;A6R;MX/]X/o<nFhJ:/^F[B_RB4Z^NmjOf^2dC4ogF
JG6n@_>4RBnBgGS8Lh[/PU4ZMSUl7SDZZUZUoJQMTVXehKK9j<oXUkJJeUPT:eU:
`CQ3<Q2cQaC4>L6DU>R418ONBIc9<8ibP/EVM:9M`DCBWd7ERJY<Te]FV@U4CN88
ag<6DR0Y4>X;co6^RB@g1oE5ZlM6>8BJ^99mGYnDXFhES8/Wj]De]cO^L[KW;6o=
[RMm4`damjmm/=RYk67omiTcWGLI?C59f]@dKe=ZPV;L6coINNJ5gMe_cTfKNV2k
`LZYHjfIRlTb8LfD?ZmnAV[mZg^[Z_J4Me^CJGYS35OV4Z^FoV;ccVOSbFG9WWI6
?VHlk3W@XREL:FHLh0mJgkOBbD9L4XG>dFQSNJdbbJIBjGf2aF79d6@@?fS=M/LV
iiVVZ:6]3Unn;6mL`:f:?beJ:EUj9Ud2YdcPm5jRDf9Rh8eN4Zm8lZ:`R;BeX2Tn
Eb^9@ZOEDk8432igE4SbY/[]?5[lK?=[ggamJNf/W:83e:;]faollBW_U7?/^O2O
ZfL>m0mL7AP85[^Z]jcklZE37imhJoOlHk:?`1<nnR9C0aI8Q8=RiT4cfF?Z4@jK
j6V2MZnNY_FLcL;7f_BZA3hadJSaj@S]Xk@FVm9W=5_a/`Mog;UjgJ36h<a:Z_^;
RR@K=<8HbA?<0k?PRC4X_J2>en0/]G4JgX`D2kBC48ZQE@VaGXSCHJ8`LEk24<j9
<iMEAK8cVQ;IfTPVYPTBS:h<E01DUJQFi4[Z@>E[89NWg__<N5BcN_ecdk8f?k;b
O_?AY;nMO_/JdKeSIFZ2kbnh_fOiDo/ofW;g^jn@g2o`N78lRn]J6;U4mn>jZ/06
Mh/ihmACe7?D1iU3RJa7d5=a=Pd8=Q/O[jA/AQFK4InQlF]e5[_:Ic4WfCLiEiN=
W3h^l=Re]IR/2RD@HU;Qg:bHP9WbPS9Al>84iMG5FNTTmIJEWS>0<L68k]fE;dd;
l_=d^Elo/WoMoP=[=alRgOEI4iio^_Bi5LL7[UgiV=cniO^_onZG5onM6YNG=9fb
GI^hLd43BKof9c87KDQEi19S`A=C:ij^NdR<^6Jgl9SUX9eVeE@LZcNXMG46_APS
jPFoQDaGWJ0_T5OY2hTO21lZg[=oh?[Bn:E;MD5k@DO=4eRW>nka19^kR>?i1:O=
bR]]2BX?_m]jd7XBm`3SBHScF5Vc<XKGZWea=Qm[lKTcN9oIk?Fmhc`@EGkDOEWe
g`W;gUUfdYU=`gZ2cU_bFm7]D0T^QZGa>9Z`36OgJSDjCKa6[f6h64mbX]^;4Jg=
Bi9/2R?_1IE1kBFaJYO5RDD/9X89mBYFPhW/ZVAK8b]?JR3eG[:Z2EJQSdLOQ5K5
VHAKJUc1>5@P]3DLBU^;BRCi;GAF?:7jgR//d6U^G64Og_gP[2cm<OjFk;XeTnYN
6oPC<Of1f5DYdikoB@m;G<bD>fjM^FcJdlnldU@`YGQkAZeEPoHMPb1B=^2mZo:n
hme4n^R;?/V:Q/C8_XfWn=ERP;MaBQ]=h_A52K6LCVU6Qj>>eOZ=>UhGYkJ[:OD=
_MUT_^5L_3jZH^6VX_>ITZ06`d4ij2W]O`O3C=fhP]bL1:=1fQNL8MOP`/S@UInK
o`]GJIoFKKBJEGF>g[kNWC_I/[ai5?D/AFkmnKHK2nTW]_G8O6e1iZCHSPJoJ407
Y9CRFT;i@HY/3c]KXdX^1EU3Hf<DRSZjYJm?2Y3U?SKPUf@?<`Fl/54/iPENcLDI
1J?J6>LCO:PFENKIZ/FZ69M7JK6ic4Z:<GZL=Z<]U^>1BkAjj7QU2XjYmN?7Am9[
lD_OG4GL=aTN_aO<_Y@@RCdnPXo;VZ_mEhL2KHcoD1KmL]`S>BE9SBBCJD1?8[T?
hi0GLFTU_l8ID3XHXDBa3KeRG^>Z[YXdMlWCKAoDY9jnXg[YHbL]oYF;3_HaVG]^
LDlXMEO>[WmRe[K`>>[;>fZg7@Q_Ydh_ciVnkld`O]ZWl:/Cd?fhclaXANN;fBNi
2ac5L7[>YnoT>WQF7d?YCA[d3/2IE4X;Kk50S5mQ/I8<Tml<iTAddMbXVLWK96Y3
LEkm6=ZAj8B8=:DADi5VP7Z[9SPO/^78S<?]Uf_CC]ZbeX_nJHGYRGgT8?8o_nk9
>Dn7Ie;?]9H/S4dXbene9?`V<X]lUdGNYdl`do6[GBK941lZE>aQMnTNdnlak4WU
D]`NGh6cdSW5?LDgfcg7]lRmf;/VITg/6WFWZl?MhNW`7TSZBH^WLO^ajDa6?5P<
RDJ[bI2^cdR9DbdA_9h23nE9SUDbPGSCZeIK?<oH<Qh?Z39iQEY3lI3Yc;CHC@TV
Wg5RRYOgYERbeGJOIR;h</aIfKg3=P>G^4PBAkQ8PaR^K55AYQAdA:=M37OU9Hn6
^C=8>^DeH7S[E=^MX<3?h@@SG2N`ZHSIM5RFZ3LiRB<^f@W>I7F/h5<jRMNSD6;4
jlCo@62BY;DjYBPg6ZE4WHk/NFAG9;VS0=YZM47aLY`k</bEmHcoog4^Qh6:Se`A
?>Dm2oM<l=gid9I97KlkmMmgC:H>/mj9SbeJDY5BLoNi/RDOOWcU0Tm>T]ZiFG?V
g5KQAV^KW3[egSd_KY_K?R5WBXeHVFZ>]fFVECcjd<D?Wj:n@E]RS5bQ5>aLo9YI
mh_H3>EI=@VAD]7391@IJDj]e5Y`>n6G@ClHe8HhfTiCm8d4/mV2mVC@Hhna9iWB
9PZGm6_2UnG=;ETA3=R7hbi__VABNThL>N8eI<LVjNfCON_WK]o>cQehMdNhXS1N
AJQ]2^7NaM@[>m0ND=0EnHcn65G=R1c>5lN7m:oY:DFlX3O7VoDYg=gdnc`_0:]F
0QN[I6djUHTgVC0<b53jHe@F2o5;c;hm]>F[YCLNI>lb;Wld^RP]TAA2f^RTRD@I
aKQALYcSI5^>;amJ3bVdI=goH[VWkc3UbU^lho?jM7:Db@`GeNDemlcm6JFno]Jn
2JVc7Z_K@WePTGRF[dPKOZ_mAiLN2fUlneFS1g;S2DDAU4<5E<[OP:O2;O8gj=T`
1dl^Y8_PJ@JA<DhjhiPbIlkTFf/3EFg;>]/jURaXTE_8eIQ8Cba4T?h3Q?H47TEh
5Z4?hCc2>`RG4JiR]`b27/6=T8M@SS0;HB521l:6b>25kF4H9lScJ=XgQPj<XBN<
XBN=XN_7d;?7d=8<AhkO>XIN<8I6oTNeUmMP1?n;a]A;gee7mRooOf]4nan=ZKmc
38fb6_GlGA;mOk5Ug/<:IFiTLgAbIF5]2VE^I6mRJPXa=20`86mRJPXf<SPh2VE^
I6mRJPXa=B0`86mRJPXXKF5SCe<PEVEbLfU_KR0a<2ha=2hf85`X@WEYK6@P<CQ7
>3ML:B1AMF5bM7XPD4A6@fm^M6EhM2T:IFiTKf9Z2S4f830PKf9Z2RQ4>S8`<CT`
>34g<CLa>3<eFS0`9c0`9bT:IFiTKf9Z2S4P<21_HVX:?3`P;e1bKfAeHfEb834e
830PDR0_@g9UHGAYKfi4HGAU834f830PDR0_CFmTA65dIB0a=R0`858P?Sh:IFiT
Kf9Z2WQbIFH:<20a=`X`<30`<30`<30`83He=C<e86HP2S0`<30`<C4d>CLP<30`
<30PKR0:<30`<30`<C8d=b0`<30`<21^80X`<30`<30d<S4h830`<30`86hP2S0`
<30`<30`<S8P<30`<30PKR0:<30`<30`<C8b=b0`<30`<21^80X`<30`<30a<cDa
830`<30`86hP2S0`<30`<3@a>3<P<30`<30PKR0:<30`<30`=3<e<B0`<30`<21^
80X`<30`<30a=3@h830`<30`86hP2S0`<30`<3@a=S8P<30`<30PKR0:<30`<30`
=3<`<B0`<30`<21^80X`<30`<30d=c<b830`<30`86hP2S0`<30`<3@i>38P<30`
<30PKR0:<30`<30a<C<f<20`<30`<21^80X`<30`<34a<cPa830`<30`86hP2S0`
<30`<C4d=CDP<30`<30PKR0:M79QJFaULPXl?20_DfUjIB0a=b0_DVm_M20a<B0`
858P;dU^IVlP<B0`858P;dU485/P?68dHSHa=3Hd<3=UI6<cHV<hHVDeHCPa=SUU
<CPh=S0c?PXlHSAR=S4d=S@`<fETHc=RHcQRICEQ>34f>FDa>3Pf<3<n85dP?Sh:
LgAQLWAhLVEV2S4a=CLb2RDUADm62P\>"], "Graphics",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  ImageSize->{384.2734375, 307.90620044926004`},
  ImageMargins->{{0, 0}, {0, -5}},ExpressionUUID->
  "eda9aea8-7990-4f99-b82a-ac6f17874668"]
}], "Graphics",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 CellChangeTimes->{{3.775045702902423*^9, 3.775045712835864*^9}, {
  3.7750511197082872`*^9, 3.7750511572377872`*^9}},
 ImageSize->{280, 329},
 ImageMargins->0,
 ImageRegion->{{0., 1.}, {0., 
  1.}},ExpressionUUID->"ad23f94d-aa3f-4e6a-b93e-7de98c9bfd51"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"Given", " ", "a"}], ",", " ", "b", ",", " ", "d", ",", " ", "e", 
    ",", " ", 
    RowBox[{"this", " ", "returns", " ", "t"}]}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Stewart", "[", 
      RowBox[{"a_", ",", "b_", ",", "d_", ",", "e_"}], "]"}], ":=", 
     RowBox[{"Sqrt", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"a", "^", "2"}], "e"}], "+", 
         RowBox[{
          RowBox[{"b", "^", "2"}], "d"}], "-", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"d", "+", "e"}], ")"}], " ", "d", " ", "e"}]}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"d", "+", "e"}], ")"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{"Given", " ", "a"}], ",", " ", "b", ",", " ", "c", ",", " ", "d",
      ",", " ", "t", ",", " ", 
     RowBox[{"this", " ", "returns", " ", 
      RowBox[{"{", 
       RowBox[{"e", ",", "f"}], "}"}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"VanAubel", "[", 
      RowBox[{"a_", ",", "b_", ",", "c_", ",", "d_", ",", "t_"}], "]"}], ":=", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"r", ",", "e", ",", "f"}], "}"}], ",", "\[IndentingNewLine]", 
       
       RowBox[{
        RowBox[{"r", "=", 
         RowBox[{
          RowBox[{"a", "/", "b"}], "+", 
          RowBox[{"c", "/", "d"}]}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"f", "=", 
         RowBox[{"t", "/", 
          RowBox[{"(", 
           RowBox[{"r", "+", "1"}], ")"}]}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"e", "=", 
         RowBox[{"t", "-", "f"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"Return", "[", 
         RowBox[{"{", 
          RowBox[{"e", ",", "f"}], "}"}], "]"}], ";"}]}], 
      "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Heron", "[", 
      RowBox[{"a_", ",", "b_", ",", "c_"}], "]"}], ":=", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", "s", "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"s", "=", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", "b", "+", "c"}], ")"}], "/", "2"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"Return", "[", 
         RowBox[{"Sqrt", "[", 
          RowBox[{"s", 
           RowBox[{"(", 
            RowBox[{"s", "-", "a"}], ")"}], 
           RowBox[{"(", 
            RowBox[{"s", "-", "b"}], ")"}], 
           RowBox[{"(", 
            RowBox[{"s", "-", "c"}], ")"}]}], "]"}], "]"}], ";"}]}], 
      "\[IndentingNewLine]", "]"}]}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.775050668837772*^9, 3.77505075799745*^9}, {
   3.775050791382237*^9, 3.775050858461286*^9}, 3.775059541958333*^9, {
   3.775159919331242*^9, 3.775160007650388*^9}, {3.775160047723465*^9, 
   3.775160055410409*^9}, {3.7758399866071777`*^9, 3.7758399972931232`*^9}, {
   3.775840568967437*^9, 3.7758405713419123`*^9}},
 CellLabel->"In[1]:=",ExpressionUUID->"d1a58d29-23ca-436b-8d66-c9ce23cde1bc"],

Cell[TextData[{
 "         ",
 Cell[GraphicsData["PDF", "\<\
9E14ARda;S<:9LCUl^G[Yo>Pd<C62S@P<21_HVX:?3`P;daUKVMdJ20e830PDR0_
AVU/M6Eb82m6K65dIDAUHfmTIB0n?PYcM79UHFd:N06=Ekebi3H<k_TD:9dR>P6R
B:V<WD^A:Qk_2b@kMkUah/;S8ZnO3bCh/m:^_>>aUPB9_hlP0;kC<kgCA?lAdnlT
m4YOWSjHWUiXC7l_CeSV=?aIOjIaYO<KbCc<937PndHL`R1amPjO8BiCX7oY1G:C
Y?>7BOXhEdU<?>8oZZC74k5?FncWm4IOCRMfC:O_m?3WCgAjYJnWI6Jf@kUGhZU`
BnK>?lH=TiFKUM]ML?MN5<?QRAWnAYjGi9[7=k]Ao6NB/10_k/1Zdg_EJ/2U[QYg
KkFk]5[f?_MFmaKR92HNiQEf`FkQ4=gFj0U8lC@F_MN`=Z_of^]UVPAhBbQ>mfKC
YMT9k<^Sj/gN6H[0bF6dGX6J`d[RDjcMRY1Z]K/B8C62OBi>7eQm0;KjS<0HHhS4
/am6?`N4NaOk>j`1mGPe[3M7O;h6]Ao1oGUH^hL3VmGS3UI<iQ7`lZ;O[KW/?LW8
iF`?@^>O_KgmfGI:G</7kE[]58NIhU9>ijINmo1j[;LkRV=?ei5FOhNOghkeGOZi
SNPM_X;Ci9W_l??k/Mk;:mmI/ELY@T^l`m>oScEf>W2R^e^`?M1ELhcLhNR?CmBf
S727eTE8I;k3fJ_GKD66@G;k?1mgRHeCXDA6Y:jLGMb4P3B<FUQS?mf7BP_3//1Z
i>UQF[0WiW[I5B:SW;5W7SRRdYEMSX<_/Z^LB[42YWbEiXL@DBVKX>UB7@ZfDIC=
C:YkZ]55C2EDGCoX4HDIWH8KNd20Co38>@GKVaNL7Wi]lJ2X:Zk^7CoJOOBh0ZU]
7VhT03FSXD0k`P^;9^^@T[E[LI/9M2Ih_4KAVVRKU6:RRia:/9bO^7B?heV6eD=E
Tb:i;SAEAP1C/jM/ZUhT<JjiD3EEB0505f=<<dhBmLO2M@>YdiH9/6WClm/Nd]Yi
mI3:=5ed3U[J</Ta[`<:o`B2374D=2hbY_JRmA^5L0IY7?`jhL@;C@@e?CDUFHi[
10@A@Pd7dDQaH4KJJV8HoJA^JPWF2:X[6`@CjjKRAYEC25GGCE1U@VeLJgNc@CDe
XXKZe`kE@NJS?:09RAD1BYlb@J>6jh`>426JAZAXHjJmM1[R5/Xdb8Y;Kd_XkEc7
QfVFZC_C9>[fALo769<dj`1D/>hdMK[Tc;36EndlddfH6;fj;5O_ljJanJF32LSM
c9<I7W]0f6A9Z20Y6DjBVYIL4M9@Smol]KF<@FHT@d@O9MRYd4U4;U@h6elDaC0o
GgB8WEEOGT^0E<HlPdagQ<n8L;ia=O/PNSAdg7?2iRHjGY:E<4;OEfDFL]Ahg38=
91R>YhX[_H4nFlih_^1J98me4E<EX@nea56VB]BmNE4bAf45J]X/5[Tja]jV=2fJ
PHFe/kN3JE/E?>h=d_?e5=KSm=A7TCi=mCWHIL<nSFU:;Pf^=X5iaT<H?Jk5G0I;
XV/ck3R=LC4l/]>:FYd9k1DaE11S]FWfgaIShC1Fa`UVjiKB67:[DU]<ZR][Inl1
EW04;MDmH?gA`7[n7hca<2T:IFiTLgAbIF5]2VE^I6mRJPXe830PKf9Z2S4a<cT:
IFiTKf9Z2S8P<21_HVX:?3`P;eAiL6DP;e1QIfDP;e1QLVE^M20c830PDR0_DVEc
KgEbHfEc83HP<21B82m3KfidIFidLb0d830PDR0_CFETJF52KgPPFc0P<20d=3DP
<c0iG@Xn?PYUKVA_HVX:=R0`86mRJPXl?20_D79_He=UM21K82m@A4HP;eAUN7@P
GB0_@fm/Kg9CL65SIB0l?20_@g<a83LP<21B83hn82m6Kfid83`l82mDE34P>20`
858:?ShP?Sh:IFiTKf9Z2STP<21_HVX:?3`P;daUKVMdJ20a<20`858P;dhP<b0_
@FadIG9^HGAU82m4IGIYHfEBAd8P;dIYK7AULR0_AVaQM6E4IF=_I6DP?Sh:LgAb
IF5]2WP1WIIgE5?I5XO?_CNmd18R82Gd6WX98=8kB1D4DHU9P502QX@VMT@5AQ@A
:EITE<01AhLRHdDD2h>2H]L9lQ1@a/5AA4GUgHa[2Nn]=O?NV_g7FMoIikOGfFO_
OMNj053lPPC2M5P1P3BQF1C^jl5L4Q?;a?L261013UP1`>5VIPA7n4@2e?bm?IVI
Z4S6/oK^;X1T^m//_e0VLmKoOi4R=d<T1P0:AMDf?7hV5nD2U5>caATbo`C:m9DY
<XHa<QJQ2J:/8^?4[fcfYnH[^lVHUbKTXAYIcQVl=9j<^e3NVRGQXh`4XEbH9N1W
Xg`7IKeDBIX0iOLXdm?hW4`0<1BIGlcW9Z5/RC9551W^RO8200RDa3VlLPj;nCUX
WP1hYVOTRPB9BF:V4MNHJNGXb6KjlK=CnF8a:iC3CN68N4c?m;@<SS0GP:m_UTD1
9EU]VFRAkJdLkNeIe^IXnKoIgainDodmb7[kEO4Vk<nN@HbNFMm/k:`__AH0mRAJ
Vafc_YEE0;A]1T3UhJa?kb00lPD0]=jLlaj6K5jBa>8<9`^;k>a/L`6OJbh[j3Ok
Wh9_b[n6>ONIbnkkES^V5cn18dTE<fE5iJJWYT]4c<`<3YO?I?gg4?oS`3UYcLW3
;9bO`1OaQNQEDNRD2HB9J;^5?85HT2iT2XAoeN5o63HW1aUnWF/DJ7EO07f5>E2h
B@O8Kcd0@b<396hoNP9mje/@<@[8_[aX[I6_LhlbN_kWnQl;G8Y^hDa18U?VmPb?
I78UXR`IXmn4K<424Y07M:0:=84^<08/H0dLP3=`0mhP08B0B103UP<^B09Y@0Bb
@CkH00Y1<MP1MX=ZL03DPG[@14j2=W06G0AG`0e`2`b0Ad0:Q/5;<07NPFT8P_0@
5J91ZY0FY0nI@]H@6eX8ND=1D3PD0lE3RI0@TT3id2JX62Z3ZZ53D3gd8g@J^PQM
PoZP1m0P=0Km0Gf44IP2df4=f02fP=V`>a`8Al;;h4Ah5I`75l3KhDZh5Sh>]l8G
hA_`02b5Gl:C243820?AAUP86o54@Y1H904A8F^A8Z@2ZDFJT0jT6kV=B95ai0<6
Qj5QV1PFaQWSQeV<hF9FHMIRBS3EV6>HET`GiSIV43>1nH:UH]FaYUPW[3mf2CHA
Vhd]a5IPSf1K/9Na0mQQk3/L3/O06N8LL7jh65`bKSF^1;L?ehbkP>_33N4VlGRl
:]hDkh8?`G?`HW`Q_PYo77lNghlOa[lWT0UJ16^23b6F82A/95@@6PSW2?f44L8d
DH6XCg@RQQ1ia5aR:K6>f46lBA`VCY<DBHHT5e8T:IVdPEA9JR9M9SdV_B6CbCYT
Ag8HFD1NCjhTWb1O9@nB?e2D:2HDCdXLAD;ICSU:^D1i@7U3YE8=Z6kDF:ZH^YeJ
Cke4ODYm;dNC<iOcUn?9[I>[TF^EjiMk9DnDeiMgUel^WbMO8Gm:oZKl^09A`D31
Dh6S/5JQA^6d`Sf5BDFJXYERR6:JHXURPn8eaE4U_9:1T[LBCjU0jK3B9JDQ6T;C
YGWB^;A=]3[JIMX`7DLgY?_CTnW5m1oX_O@9IBEUFnDXiAcU6^FcbU86`S1Pn3=B
6JF<ThbkS8oc=>Jicn??fcJ_JEko_2VEnBY^:WbE8YEVU@6ESjY<EFoE5=FMZVfZ
Cm@`JRIZHF[IJ__E;Z^=cjO?Mik?WEldonClQnZ`^XUj^?YZmL?Z?NZC6YXJ_QXI
6UDJUcC6=AVJKY[9V^FJicC7]6QJ2kD4F^EJikEN<9FIk/aDIRFcRcVQ[Jk]YbgA
?ZCMZcf]HjRcF6NSC[?>4efB;U/g@KML]e=g@Tm;;eP_GjmAkj4nDIn]WjBoAkmK
Ol[0d23JH8]1Vl6XXHZQ_f6NHJ?QHb>ZTJ_A:Z=JXc_6>6>fLH[a?^=K9[29WDVB
BHg9CE?He=iDH;[?]<l<JnIX9SB[=K_7X[3LFEV/A]JP>L<lb7bSNI_i:`/mReR;
WAKM5Ul/kBaC;N//7eTYF@EHKKCZ/?[3f/BJJeeSOLN6J^=S/ljVgNJe[JT]ggJo
kGdkVUf`gAJkC[_?mPkf8_/Vnc47?HMhQkd>mmQdMRRkQ7gE4N_XhKS>lHcS1bMk
9k7CBJOOWEW>:Lh=cZ<;31O`5m@]67;ALN6h77:A;V@^S5mhL:7DEM^Ehe[[n/a=
ehgWM/A]a=gH?MWm^?/[3d/?TDN;aiBWTnLJc`]NR9N_Ei5G[kNBmf;_J^nW?SXn
RCj=?Q>nM[j[OBohHOd2oGKjgO?Gl>Ojeo]?13P4[0WX2Z@4APAF1ch;<PTB1GD4
`l41`K^27boBGbALe1H2@_a3MXDl2CD<GAGjLaP^;3B/9^ai^5EhOWQg12eRADA3
a;]8SlSBb4N;SAI;5WM6bDO5AME7CDEkAIM5BiMH;5Vci4J<FX`PYSdF7a/ENbAf
LZWgd]e;Qn?/hP[SkRhcG9Jck=Yb]NFYbln^T5o1FG4Z7Q/O7Ml@ohTC`ZWUC:kd
GkUgi@CGTk^7ni;WaR_WSO5Mn6GlT@BGQ;:4dDBGa5f9HdV^BAE9h`9?@KGPMK9O
lX7TZIB@U:<Y<jWAZLeYQ;Ch]==29F6:/2]M<cdW_Bo3=:<`@k[:JMG^EA>R@=6A
C2QcFFJkV8knC?E8S2BK9H=I2k=Z/]iWAfFObU7<4NKdi9[TK//MbO?9ngheISEg
MFNnM_j6o<4ekV/>[HGF[UcK^DigGL6jhOFnjhm]86e8fO3;A/^=IA_OKX[Ne56P
DK2nH6RcknK6@[U2DN6m;LiK3Vc5K1E/kMeV/jeZfiLRG]7eH/_RR^9?9MbBjmmI
OEOigLcfQ>fmYOJUngOPMPQgg=gY^_=HVF9IG]W@[^1M[NG<lZ;b]k]Gk;iFHE]a
H0mYSfB?]3:X/[e:[fY7eJOZY>Z16XnJi[gZNkO]WM[7fmNogfeod`6=0lD7?QhD
7;aob?M@Jje1KLEQg>6/`lo[X^Zj_fMoGgm4kDSaTLm7QDNUal:?MMDke=LgZ3ND
=/:=T/Jahg77KogPmD=k4j_YD3>S^OP4>24ilN;7n1o_WP`lfGV:OJ[Y9ofOm[K@
FXYJXMKLeXVfY3IYNdakgnV0didMcQd]?i_oO?B<mYVJ/lYWBlnAcQFLVcVOMgkb
@/J5lH^95hLjEg@n^[CTdYf^/:kNbh6G[eka^G:Yfkgko5FGZfN^>EdkOIem_Nf6
oHgF7[^NUUo/OVWY]Nm]_NU`/ofFhjf>_PEmioYMnboNm[YmiHkoWA/3R`KjkRjn
NomNg3gYOMkmd@NY3ehoc7XhoFSmHncSXRL:CbZNZSn]oMGhefJY_OC/X=MPck>8
Ihn6^4<_oiGi[do31LnYcb]6]4KZAje7chciS=ej/OC5l<^<Um?SQKlYo[KgUM6[
WgignkeWH/W4l6_AjiToB]jX_SWje_I]ifCXi==gJNnVYh[NZkhomX7mXO]Sm<NA
jNa?n4nEWhdoMg`9o?9h9VeVi]ogQ??k2VE^I7=dLVEQK@YUKVA_HVX:<C0P<21_
HVX:<SHa<PYUKVA_HVX:=b0`86mRJPYK82m9@d=2HG=UI20i830PDR1M2VE^I6mR
JPXc830PKf9Z2S`l82mDNG1U82m@HFMULb0_CFETJF52KgPPFc0P<20d=3DP<c0i
GB0_@fmeKW@P<B0_BfUTLb1K838P<21B85dP?Sh:IFiTKf9Z2S4a830PKf9Z2S`l
82mDNG1U82m3HGAQK6mW82m@HFMULb0c830PDR0n?PYUKVA_HVX:>20`86mRJPXl
?20_E7U`IB0_AVm^M20_DgERM7U`IB0_E79eIEAiL6DP;d9QLfE6Kfid82mDD5Q5
CDD[B6E/MVEdJF=Q82m6KfidA6EcHg9YL7A_LPXa<R0`858P;dE^HfmTJFiW82m=
HF=BKfeQKTE^HfmTJFiW82m6JG9cM4=XHG8P=3TP;daQLgA3J65b834`=b0_EfUT
M6Qc85/P=CDf2SDe=R0`830P<20`830P<20`830P<20`830P<20`830P=SHg83Hf
=b0g<S8P=c8b83Hf=b0f<C4P<20`830P<20`830P<20`830:=SHg830P<20`830P
<20`830P<20`830P<20`830P<20`830P=CDf83De=R0e<30P<20e=CHP<SLh83De
=R0e=CHP<20b<S8P=C0`2UdP?Sh:IFiTKf9Z2S4b830PKf9Z2S`l82mDNG1U82m6
KfidA6EcHg9YL7A_LR0_AVm^M4iQKFDP;eA@F4E=AB]8IFafIGAYHf4P;dI/HFMc
83<b82m6Kfid@T9_N21K;CTe<B0]=3Pa834d=3DP<C4b<Ud:;dUdHFaYHd5^IfaU
830P;d5cHfE^M20g=c0P;dAULf=UKW@P;C8c<20_@f5`B6EYIfQd83La=b0_DgAU
KEHP>CPP;eQ8IFUWJ7@:=C8c82mCM6E]B20h=B0_@GIWEfUTM6PP=3@a82m=HGQG
JFAdJ20a=C0`82m6KfidAVU/IC8P<C<P<21B83hn2VE^I6mRJPXa<b0`86mRJPXl
?20_C6E^IgAX834d830PDR0_C6E^IgAX<B0i=c0h82m6JFadIG8P;dI/HGAUA6ES
KfAU83hn2W=dLVEQK@Yh0KeJNgcDaKDolg__8i_McFkfTGgVUmg=>b@Q8B61;249
hI4H268FRBB1@0PPTDLD:S@PR0BT8PD/]2YENHYI@/@=51]Y;?Zi?]0ZERje]J;e
NY^?mUkaZY3MNgjo3BVTjXLoo7AoWc<cIfIn<fNnLnK<VOW]b^F[VR46>X26V]V=
K@]0oRD]0B0MliHf]TGi>2WJ?ZmmYB_:/lT0m985K@^GAWWQi`1:nl8UZhONS`/1
J2]KVQ_WAl_Q6/Ki;IPAiLUXS9=JUZjl;l[[Nc2N]VCI_:7b^4N@CekJN=m@og09
NMOMSD^KXoFC:S5>JU^fH^D@;dFEKL^KQnZC>YC_CB2H6`N?PP8F0`lDJ?6Y1n0o
EMZ1`E:Y77oEWKmiO6i/lAG@2C8o]nYWL_cNbhLfO=elcJOJ8Gb36H[[mJFHB`VW
0:P9UPnXMPbGb>mQP03DYXEP<U89DQiBF]X4<gB@0o08dY=8=2`RFf4edQJTGb0a
`jW3b?FB[Mf<h3m5EX>EC?6[6>M<PlEYEZZLKhL8eo>hlggcAjN91FO_@f;YSP75
12EiTS`1ll59WP4?F@>ET4cfWTQIhVc0X/?@Q]B1A</Q8HNk7CW>5dTjN1R2kgS1
`I2Cc[mUIcPocPiAY=]ieQMR<7[9PI`oe]UWOmciFo]2ih]8Aj=5Ae:`aTWWHO/B
idi7R>c]MSiZ3a5lIdLdFVG7EdljUjK/M/k?U/^Wk@iAAk^MQEPnbjmbiQNhWGWf
blh/GdPPb6OHYcUC/emg9^6;F<f5SG[l>ZO=_]<i5X/LmW;OF:CCi0SI1jUTGkMW
R_<D9W6h9bJW5>`>TInLZ4c>mXC86WmnIO;^U4ZO9fFJdi=BhO=QN]H[o4KnCWh2
Wl>WlLVlUgOc2Ka1d0]J@B>X1JDP27b8?=]Mh^A>Tj=@P[0L?B5`0Q/Rcf4VLiXL
Tc>?_B0`0RF0H0Q5oX;:Bl0@8TMk]58:4bLi>LF5b;4CdJaSORLSYARi@4]9J@``
18X854b187Tha<6Vn?HBLhUn_:j`X^ckPPJii7ZHm_do<k47Mdn][@/N/@N2>E8R
HPmL[fjnW_SNN>DZ;6X^CD^K>V?eROJfePGUcF9iPeSNS=@@g=[NHPif=;ULae_K
Y09GT?Hf=<e[TN;6iV2Kf5`FK1G;G<OKiOM652n@R]_5/^>`X7aVgO45o^JbkWIo
NkWHF1HhdEBj_?jV_[H<mkFlm3_j:YDJFbkeeBBo=j:_NZVhBNZ[G^Z[G^Z[bMlT
mbD=_WaAKNV:UJRM[_95Deg1i=[Pi>Vcjh:^aT1IR1c0c;9E`?J1USd3bF`7F9T/
L094gTNj:<GQfb>O/>M06ehJn@MMQ9?J:a4E;RV6?WPHmT4GL708dlU`5c`6[i9F
G=]cX0L^40MTX^eU80CCh3DBRK`52n1Y[;lBc/8^>0iZO6LY6;5d>o54eR3_ag@C
K8cl6Y:P01j4<e28[Fj7PLSQb0T/W@6g`a4hR^oo1a6YhdaLi;W8IA1P>[Ji4D_N
RTb;M84NdZ4DJS1g8ka8??C5B0^HX@RUnbDl0O_Q9OPkfD1j8RfAm/Sib8NXZVJ`
@BdnJdT?nI3^HQj<o3;bFBB<B2A3:_KJ03_Q:Fbo2iln=:gUI35IBGJBGIBOfT3e
<9]HDgP@LDR1BOQD`S9h217XQGkh7oR6O4jIJBfmTWhiTQOiGe31E1bU=99VJ<MW
<ckKLDbW2DM6THVTQZ`U?bNkb1nXE>YfZXjjUkZ?nXB^Y^O@ZnTo<2^HKWHKnaRW
2Un9W8jLRk`;9[33WK0Le^7Xc/9in1:n9CBfIB<NDTA:bEghM91mE2oICgZY6]97
cU=7b9o9AnAcLYER:CEUY=:XUMA>jRQeUWZ3GTC_XWm1oiVn`XaW:GHonc7WhOlc
g1CN4WhSDQCi<?8eVUP1g3PcYE0=Lj4AAm/6Xn6W>8YSn7CQ[?G3bo2Zo7a4K300
Gb<:@?C4BW985CkEi3JbP2`RSi=Cn;`Xbo8EQA=1:BPMIJ9/E2gEA2fU>ZQgZ@hj
PDjUYm2cjBilGZ4_d5OYZ`c;a356IQ8c6KHaBiVmn1aP3S7Mc9]/8C^N[FIW/Ag/
5WHK?HmmRkg0[N>fLmgLim`GJ1JWlL_hKCPk[j;>_XBjo<lO@i9@nQbh6nJA<]84
^g4fmY=6j4C]VTlN@[cJ83UBCjnS9e6SD1]NQ9nP]^j5]K25WP?k8gnTSl1kZ2WX
Gj3N7fA:`Lk^`MWI0:=@RhHNOdYZB[;?jdTB4md^=?Vf1:_5K8Xg6^;d>Vf<FZED
23c7<SA58;eL[6Q`1Kd=@LH[EUIVB;cHR1V==f@dh59f1B]^[Q=dBNleH]5==OeH
Ll68V_iXCOm`CJ9e5D=aA[Z[G7@5GblCGB4bNgXMYQl^4`>^h82L[Y;CSlSY64bk
gOR2ZmcLD^H:TPIGNK2R_JFc_:4/8igdnQ4>IDJjI3SlX98J3/;4a[EXH66RE:<l
J1G;bX<F4M=HAW_:6nL7JjKGUILU^=d1c<>/6GGHAdKjXR3:2E_EllGiFd=nJ6Z@
DXecjX9dHb18=DQ]jM:29[4/J5[c/OVOk?EDnKHK2X>DYj:a^K<Rj6oHR^1:K8?4
=Fi3KVZ]2i^U=PGZPVCCT12BS:dXZBA^M4o`=;BjPPZaE6cYK6e0L656GKOEKiF=
Ka1Zj[X]OX_<I:CgV]LE^G7d_ATC<RI8LI7K_2hJonf1J?kKOE9/G]Oo5hbWcQP6
P4P8R9=AcZ1[W]b9R<8FB45c0GC>:d2Ll1LP><a5:<o488Dj@g^2[6MbHk2Sm[XH
;FEAhAYJbkXE5Z^l2ID6/7i3YgH/cQCFehZ^cR^hFcN80gno>JMa:8OcJ:n0E2Q=
m;2^14WSmGBk]5UjL=@]I[55V]mfNDjA5lgU=f@P;d4SbA`dh0INDnL>^P:HPMiT
n]@@:6[ZSQ>b?A0RTDdQ:;?gXXm:ckd;Rm<UEE]DQ_dSTi6>6JU^C6FV^bZ`i`Y9
EebM[/k9lc]M5JhFE2K68lMHd=`Ib484Jn/@9iR9?OX32L?9iT1P;;JC9KF3[f3e
cP2fd3[D0/IbE]HPEQZESY/YkJfYVehGk2Q;2?[;0SP;Z;im=GG1?]CL@01[I@m;
RQ:_GF@NTST7ILi>aO;LJ2_X^gAP4h7>CZW=fS[A7Nc[k4cXU=IKU0lA69WQ7lX8
PEA5PSa4>V[`GHa4Mh8l1fkASF8594a7XdYOebSdfGlHhOaQ^O7=<BQ]_Xa``Hn4
L>6]83cfUQ0^6YKd9XB;DNHR2N5aocj4amn4L<T?8n`OUQ^5W83BnVF4BglTQ2ON
2/9U]hA`nK2T=b5LPC:GB`Q?n_LQG7TC`Y=o6>4Y`g:ST5=AfRTb`]=n98B[KPGQ
jU]2n;IQBFm2^0IU_Te2N?Zo3n4I=b5Lnl<8cabF6hFl7JFM:B<ljdM2n8iK@KS^
UQ0>34]j4l:cDNJ0Q?2M``Sk4h9`Xag^665fhDLgc7=^P1`m9EH?YL`:j4Ob/k?0
PK@7cencTIk1M1Oc4GC9l@ZHPGGJlN1MQ74UE@PfS<LQKBCW8QLa_`>K^gh?Y<KC
RLAWhcTXNSQ7iW]n=9kIF:c?Xioo[co5_fJ=b57R6DN=NC6PPERlU@;@hIT/n/^7
>O0YWYfnYQjR?Z<cj@Kj9=?1O<H^hO:i3G`Z_hK_4I;`850:`9c7<bV=DTb<gSL9
FB5PT0@]G/2MAi9hC=>G<8daSc6=/N8BW<:g06JUWL:FF8a7INOZg3XODRVc?GC]
[nbIKbN6V:Z[N7n1J?CS=LFkk:<hF_6h@48TejmV65k=l;]ID4iBJ=_kcOg_3QI2
BLVG[fN?R//KClKTjTAMonofN[OgdEmeaPD>O7/goIGLUQoUM[2oPT@hh:o>IbZH
>mS5m[/MJa`KbFI:B1EVFaIKk[OLKg_N`T8RRFE/6X^K]eW`SXYea/HVaRWchURG
LiDkDNgn:El@_baAhh]Mkba8C9XTBW:l<o3UP?K:`6DX:Ah/;QW@j@^cm:I2P[6n
/5270MAWSiZhfVmS;6Z?cZ_BJi91HN2CRHF9dBZCRF3406o[]5XRG@j/QoYlO@W9
7i>O=mX[9_8L;f;JWJ<g6WP^UW2HhCJjYfajZFomj1VkeoI>lS8_d:F[B?9G7jf^
N7i;Dl5l:jfiU]9;m6g;Y^KE;UjkLm_DCJOKchNoN^[I=I>JYnEWgm5j176Q`H6J
?@kWT`99>bkjJbY97FTQm4?d7^HaiF5UB15BL/U:0Sc74DY@:31@0/nBKHAVG0JU
dZ?7?0?;N_AH@JERJHFBhERRXPP=U8<G@RCPEn2aRE<XJAJi@gimC8c9I6DO9hl[
;NZHoNi]Mn6]T:GjBg?Eh:2U^[bik9>:<S>DV8Y;RZ/64DiMHHT4I1C9[<fIJF^e
Dm6kHoXBPTaoH7>VNBR3aPbj?i0fE7Nc][RHAlXNAN[[XIjXB5`^4FTg;A9jnil7
=We86Bo^6Scma6_D8mA/J/_P_OBlKbNBD;QBe^hmR0^3:BGNPbC31Wo1k9SI^UJZ
=JIE]hJjele?SZWDDGK16L/hha13Wn0`DBZ7Cf2b4aK5IX_FE8GATaa_BDT=TKTW
g>d;L8SEGd[SZMInEHG:0RF39@>X9H>bT/RjXCMKFL7RhKblVDTS[5E8@hf@e67m
NQ`1bI6D`NLEgKXKT[CK9IeADAoRXg4:XO[GEMbmZWA3n5OTf0_EfCnK]SJljWOD
_HAJj[l]YNZNPWV1CN4?1WOB=N:HWcfBH`/G3/i^WCSgbK7>`J]/g=hkkmdJb?:U
iCLLg[kRFMB:fI6;k3g/af17CCW^;dYPmi3M;>dTCVH3fLa^RF=[1OY1^diWi<KJ
JOEHXl91>A`F>Y/ZdVK[[2i5]/GRM>eg]dH1Z1XH6Sj>79O]P0b1MT0NoUR`VCaa
GXdW`J^:EnA0S46K@oBjF2e_@hh5>XL@RZ6EIWD>a>Xa4:aL3V481]:B8MYRKC4^
83VD<]KGTgZ1V<A<8RJ2CZ_?A@37i>;BLK]lGYdFUi?8><QXgEWgbmg_Qjolho=;
:lHicUXOk@Zo5h7W?Wkf59VDc7hL_WQjnh7`Vn6G`n7`K`l7MWcjZc?kGRO?T_;c
OlGe@l4cZ2OcD4mRl:iZXMniFKMKCnD8:TL/1@jC86C7FJda7Xg5H[gPK]lR:d7E
X8b1Y023l/2m95kW<GXiW^DIW^HYW^FDFP576hn1@Zo:8K`1Kcm`R6UYZM:h?=98
9=^PYE0KI1G@6GP:YoillhBEDhZ//Noo8oc4:e@]bCZhZfiOn<71[R=6gk;0e]Y9
A4Lb[ck6a[eg=_cFIfO2gO8H^]0f3^0HY=fQfYo4>aQ6AC]`=e883ZE:D5=Z=@GL
8ZY8HMG@PPL/<IX@DIe`kkXn85VY_k`/FCfLELT25/^jSDHIcIA^R4PGTgE]9ief
kEgjoZ]W:BMkYRMLNRB/jL:^lDO`SPNH8lPXX=1_UZA@34W1;BIFUMbcDQDRMf3?
UhJPU7]6Zo^_7HYMm=E[[e5_3FJMTc_Z6Y`_cIODamOHQa8<d>S?FjANY5n]GZ=W
:PeeQQK36P?32`jMEZ/TVUP90JE0LGXeXc0H/QU[O:`21fn<ohk13n[@g4O7[TDD
40:21[lncYf3Zi?3FA91G[[^W?bl;VYGoaLG?PSWW:<kkR]M4Ei9]SehT3gcYeNN
S@c^I7[7>/?dlTLTfc`SLTVnBH]5gj0Ho^@_B1e5U5YEP][VbjgD;U:dJ_U2@JmF
d0TiO9;2[UGKRm:Xc9BR5hZXXYaDSek;/h;=UfRbQDRWGcCIWKc?WZVRk7VZH[jh
f6KPDe8?9EW79jCHY/Cj2RcSa_n6k<4;a5jb6j;`XYfBM?GbH?o`NRdI`9VE1U^?
/idiT3TPVFJMZE3Fi>Cl<LI481H?bHmePmVAh8IhUl5=g8T`QW:3eFib4j<K0eAV
JL7:bg@mKWJT?RUNFYoSR8K8fi_aY[e_?<W=@O>V<f0Uk4:3:m[WmDVA=fmdoYPh
XUUN?CN`fmfB/k@Y^iKdS3NZ7eScL95KNHSm_jO>]:lbNM@>GFZj]cheGS7VSO]g
WCVeYo?=fNVC3n``fSQ=S2e[8ETRY9/ci]A>BjgmoKk:b/L6mmPBJGZCVR/EoIF]
ccndjnThLUWBWoK81hb7?H^NT`?Jo9T7n8>fmfadXQ3[X5P0TigUMDZ7GJDbn0B[
biZYcB@YX4<C^=UmY_kj7W3ilY05691<X0km0aTm/cjNDlIc1RoA:c4`lRH_RE<h
_=6E;l4DUj^CX=3[39B<P55<RSX8W=5PR/m]kbYj^^6EKkjj^6IVC^41J/6>7@oo
Y=LkjBakM_2oZjJ71l9OQ/?18[5ZbmY?Gccl`LVgm]aeG5koN7]<WfNZ`@X9L=2O
MM127S<O4XjHjBV2KYn1YPfLgL[7f0fZ13hQ`JCej@W]XgAF^m9W/]S`TaYo`[el
kI36h<R:Z`H:2jGe?m;2S`J;h54KUEk@a6UaU99]]b27]]d]fgIEO8`GKC/62S?W
UFbknc]/^j`_41nek3`>GMJ:G4TMZ3`]i?;DQHm<GM[UjijM<^ZQAm/N/7@i_SSm
m[M4ohj=Z@jn=nn1@d^Og7mYbkg__Tab?l6[kk7H?eBRIfk5Ff/KO^7`4;EomAkQ
5mJ3CY[ED;6/`JSAaaX=O[GO8:AHbECEBOXLnCem;^6?`_^:2lhoRYnJ?QEEigCW
m=@LPGDWaNj=]bLELS`OkkKKN:DmG^GQmmP>fUi0GF4llK4N6f]AZWTMnY1f7f_e
9FGb?X_5jg_7OB2Z95F3DAEiIe3fNVCW9j]n64ld;e[9aiCEYP94QZGaT`1Q6Lj9
>i]N6jLeJ1U>kDU<B?:22naNh[0[C;`GE4J=UlAXA:/K/eP<13?RSajX5j@U6EfC
l[Y<CD]MCnjYQg_@Md;G0UNOfh6Z9ffQ6X;^1RM_ZY1;_6SG4SVND3dG2_;efV^O
/ho/NGSV:<=ao[K/6J/Wc7PUo1TaoiDhELUCS]eoR2DR<fWakM>GC?WeDboGidlZ
fY5IHm<B4Kn;D:@dk5eE/N549i4n_>=nH<<5If;OaRlYEOhdg/hYkCB9=AC6ag1j
Y@EMB4f<;/FTioFa6ZN6dU`cF<bFJnj5jhJfQ_[2O/T>JfF?DS;=j7bE3;b3cXIn
C7i^C[c9:7T6W37G:>:Q@Lc;cG]N;>WA9IU/5]D<EgM?mjiMK>WX>ACe=4E^Ofkk
]OWd;kLO@[UX61L^XSm5GG521Wi9Nl5OUFnH;4aFe0T1aD?Z``V7k8Mm1m9j4eAn
PHi?C=7d:a?Am39LR]fRe=^E/IUlIRI[Xc?S<c=BF>/X]LHG<mk[/eVbAVef;blM
][b5TY4H_7aUJ5M5G`V]QCc]dGU?5i>]3YD^bJ?eRPj_5i:]6>QD6SO4J]@a7W^R
UoPBDW0mZOE^NGJ7?2BLi_FB<@6LeKaLM1`hMj;GUh]C;4f_K5FCM;R<@3ihb:/;
G@e2gGmGK]j1h[K`ZlOn[WTQaSO^PCOmGS[o/KG?QJlBoQ@YNoZW;eIhM]iom[Kd
l5]<jGQah^I[>JneGmcgC:F_n=5IOiYAlgo4CV98IWQoGoOL_LnOjIZgTLZ@igTS
PSZ0=SDNJ_gY^6X44flBO8`_KQFoBQ3RHZPh8aiEkAa_E2]SDYAF<c6V@;c5I<Io
99a`=dDQ6oJ]l@PVFmE28Rd@fFRR[aCM@4BMi47SY>_4SCgng3/fo5M]AZlSNg?K
bAhdTYNV^`^O2S`n>9ejZWe<gMh;Pjm8NTQ5;XI[B07j33AJOCcKe^;aEE;?FOSo
2R:MKlm7ckV:loQ5EH<EM5VW/:idcQfECE2ab7RBYi>AaPg;A`YjN/:oGYgMhbd9
a]RMc<3iKdHchQcVi=DaZlHfDM:;f7P7HR;i:BZdb?<351T[40^52lo4gL4^I5Mc
mo6KfEkjEOXR[FAI3_m0X:2YSMC?DEUYZQ2?I0b;7j^hYGY4Dn3a/aG;:@AFLYoA
oj4i9LlY>F^<PU:VP0X?HMg^YUhB7mge9B2;;MGJCo0<EXbNG8Vdfa>TcEFIJL9J
kD^<M>BZImMZnkA2/B2O[m1<;<O=RN@ZL2Wc>[7S67WSTo02L_bCL?NNHnbIJdO9
^O2b`BK:eQVn6lM7BH?4[mS=n:ge^gkBGgl<N?92F`aNl>49;0DE/Pc:X@:ohTk6
?bi<QB[lbRTQYDNBOYadXc6cYZjlZSb]/WU9No?:AO<JiAYb<@HcTAZ@fY0jT=39
PRNAPTQmB>NAoX;dQM@/TQK9QC@:bHmDPmB0e1HInP7nQ]<4kg1^iW=6l1=6l:DS
n8TSn;8AO?T8_V84So;M98ldnQ_UJa[1ca_1bg=a`gPFS2QO>89_6L6gS^0GBoco
0jf;mI/:IFiTLgAbIF5]2VE^I6mRJPXa=20`86mRJPXf<SLi2VE^I6mRJPXa=B0`
86mRJPXXKF5SCe<PEVEbLfU_KR0a<2ha=2hf85`X@WEYK6@P<CQ7>3ML:B1AMF5b
M7XPD4A6@fm^M6EhM2T:IFiTKf9Z2S4f830PKf9Z2RQ4>S8`<CT`>38d<CDc<c8f
FS0`9c0`9bT:IFiTKf9Z2S4P<21_HVX:?3`P;e1bKfAeHfEb834e830PDR0_@g9U
HGAYKfi4HGAU834f830PDR0_CFmTA65dIB0a=R0`858P?Sh:IFiTKf9Z2WQbIFH:
<20a=`X`<30`<30`<30`83He=C<e86HP2S0`<30`<C4d=30P<30`<30PKR0:<30`
<30`<C8e=B0`<30`<21^80X`<30`<30d<S8f830`<30`86hP2S0`<30`<30`<S8P
<30`<30PKR0:<30`<30`<C8c=B0`<30`<21^80X`<30`<30a<cDi830`<30`86hP
2S0`<30`<3@a>C4P<30`<30PKR0:<30`<30`=3<e>B0`<30`<21^80X`<30`<30a
=3Df830`<30`86hP2S0`<30`<3@a=c0P<30`<30PKR0:<30`<30`=3<`>B0`<30`
<21^80X`<30`<30d=SPd830`<30`86hP2S0`<30`<3@i<c@P<30`<30PKR0:<30`
<30a<C<`<b0`<30`<21^80X`<30`<34a<c8d830`<30`86hP2S0`<30`<C4c>CPP
<30`<30PKR0:M79QJFaULPXl?20_DfUjIB0a=b0_DVm_M20a<B0`858P;dU^IVlP
<B0`858P;dU485/P?34eHS<c>C0f=cMT=fDbI6@a<SERHCAR>CH`=C5Q=V@b?PXl
<CER<c<i<3Hg=f@gIC9TI34b=F9Q=68i=S0e<F4fI38n85dP?Sh:LgAQLWAhLVEV
2S4a=C4e2RDUADm62P\>"], "Graphics",
  ImageSize->{289.19140625, 200.80931355337077`},
  ImageMargins->0,ExpressionUUID->"4eed46c5-ffe2-4a7e-9a34-1dfa8f592e54"],
 "    ",
 Cell[GraphicsData["PDF", "\<\
9E14ARda;S<:9LCUl^G[Yo>Pd<C62S@P<21_HVX:?3`P;daUKVMdJ20e830PDR0_
AVU/M6Eb82m6K65dIDAUHfmTIB0n?PYcM79UHFd:N06MFK^>I3D@cOdE3YL0ho;c
>V@G24P0kO`0]8@@HP:d0Ko?:M]EMWOOkQW@BZ_[djj7bnEjcMof5o^g9O^S3OI?
nlfW;f@oOKHNolQno]Aoh/GGQ?mR87]i]JfjU4Z:=U1f[LAV5fI2>5a^<MZS^^2?
D6b8Qc/RIE^CboDh`T8^]Y1[ZLESHIUL9L:VbLPX8=8^ER4OGH`Y;cKDX_?@J@UC
i69D9LGFDHCC@YJh?ncWJJGM50JVX40^=1b9BW>A:Y]RHDMbPD:ci9/;8BI;[KQ`
e69KLS4LVA@a5e^KBc7VXYP]eLEl7=6BL5Z8b8<9MEM>;XEX5Z<DG4bPGn84^Fa:
2KHD7hcd94I?Mk7W]V2g21kR4n6h55c;:L0F2h_57CUF@dMf_]A/:L<FhH09h0=D
H3Y5X5b4mi@35]=ME=gAh6^TW1@ANJ0Ck6S>i`AK2R?HZabNSRE>TL]BBS5EG1PY
X:MkI0_fR`2bN11^3TiOFV>oD2c0eo0</PdU^aXB`MN[bk5E_8;RLZ:T2?`Rn771
R/4MXZ^Nl;B4Tb8Z3kJ@GIBbbeB3DDild`Noc2U][R5;=98MNXk9@dmQ=TW?O89`
/8cch<Uj`YWI9`B[o=A;Q?VCZm0@c14lL4?9n@B764^L9>6I9cSDo3e0kN9Q_lT0
SSX@Xf90Y;^RMm4O^7UU@m5UK=dT2L9V6lZH8=QBF3P]A8keb1WhHA1^eaOOC82W
Nh[DPlC0L8KR48hZG9OU`VG78E]3/8`=PK7Ki6:QETALWEHa=CQoE;R>d2/P@Q1A
I0l^khP`o^8Af@8UF15SPR2`P6XRV9c01^6dT2E^^85g3LhMLcCNNEn?50WQoF4b
hNN4VnAkId/QEJ@PQok[HMcU^ifFPD?5P02B>LhN;]@JkCTQgdGf@ebGIc9NJ@dI
;PLoAnaXTc;JOgX:m8mBh9GF`PEnO<FU9m?;UlWYbdFC:MWRTC`3:oCa1Gk9^IDM
WcnlOGTegkbl`3_]bnof`nD[no:WoOiUbd2Pae_aQm07YXOa9[GMZ>T[Ld^mYg9A
OAT0iUbf_KHSabWK3Xi_Ye[_LTneARY/jDaYlo:j4hOk8nm:K`[N^hcIDcGIRSZV
R/Pk>nm2OkdG2W9hKY@3?cGcgBG]6X]OVo6H[mg`c/RL2]oDfK1_W>Z<0P=:biVO
:2eV=Z<2g6/KY[ij:Vln<[8a@FijWg_lMVK/b0la_LM1j9il=oMm@82OJ9`a]`I7
l@6WemOde4]>5BND<j6TMoR9V1b?VA1Sn8fCgB:3W89I8K3?LUTZdB^<llN1XSZS
[^UY0JE?;lIGVCdA[RfSBcEabJ6k40M7<@iTL5[8;>]k1Y5M2OEK@g6i><DkNA<1
gM9:MZgC2:N5Z;`ok4NHQSgAkfHQRnSNN_=a6WWfN?WC_Fod<81G<@?GTbMAE[Ql
N3O<1WGl[=nU3]najU67QfaJiX[NheVPD>WM`B[41KUHM2aX3Q0HebjDkJ<kD4j:
R3c@;@aYSm1N;4kL4g0jFo8V0UmHF^V^MA[Q]93Ieg21LgdgQU]2KQ>iV4N:WmIm
nWa>;`NE:;Aoan_9jfZOg@kJUCPk2^T<l?hGQ^XbLh`/0MD2gPCG>keOFIg8A60]
:RQS2_M^^P]9Lo@[@0JWQLc>1g@;@jfMFX5FbPTe4_M7Vkb9/3cEBWOYJIBC8R[_
mWI`;n=fd;]aXgin?CN9moAjj>1RAAoO`mMS?ZCgg@mb2LX_kW:dQn0RCS4DZchU
E:CE5FkQ40Qk2kGJ5D7@/4AnH`SNfbj<6@Kc`@Qk1[:g;8:13YEGbaQV;4kQC]i4
F5iG2ZadTnZ]S1BI_Momfm7K2LQgU4VLokloWUjm8_>Na;JKbhg__1dZIKIOd]bl
`WLE@jf=@0DocHk@A:6c`lB5>k_E]PTb_;TU_1kI1DiXBWYcUiFC8[=777ASEfZ^
XM9U//48`9Dh4`AQ<U5:/:Fh<]:CZ;CiM/aMe/4]FcB_oc^bX@E76BFGno3Uf0mG
ML63VP1Z6>;N^L:LdWDQ/2WDkHVhi[d[UM]kQ;cNKTZC]i2;JHM;YO7/@GMQ1S4j
C]PJMeaid2O8K5bA?AA3P<?=U8dCT1]iP^1ZE2_1E?79B4jbf^@Wk`HS=hcmg[RH
GR>Oa[@F;HinlVK@O>e=PABJ:96OIAbN?mhdTZlKeS`bO4SXnU25E@Z66TINW9ma
m4TW28JKb<4HQj4942`SVhlfECP9/UY>d>T^C0a`3g0miHC9ihdl@C0oE:d4fdhc
>Fg8K76Og0d/Bc68ecl=JCnl;bHI`^AU6`c0jaN0`IkW=17PSbQbKH2A48edU=2G
L41<HFXlXY7O<I0LX`IUX0P2^6D:1F1JI6cUPM43RUNcI?2bDhP>7MRD50I;kB7S
LNQ1[oef5mPW1=mM6A5UfDU3`Kk>>NmjCW:5mHTUJPD<OD;5M8d8KX]Y2Q8ahT6O
[d`49`dA4J5`2QL/h6RC^g9B18k8W9Q><KQT3Ccb54hN0f6NgRaiPS2MJ3DaJ:FW
DDj:37W@lf5I179D=Hf3jVU;/DN1kcL3>fBj=aXg8_H66FWe1DiMON_V`Y@?GoQK
2S]YKd[k9mb=;MUlVcmQUYG=X^?Uh<Va]2mP;Pk0Rc2PcYTlnbOcW>9hKJIRRdke
O68Xl/56kbEHGSoWVa;Sfle@?F0nl4@LR`o3YgP5LekPUK9M<26IUP[XKh1g5O/W
W01oCnTWW[oe3I<@/bWURIeHP5Do:EaJjC005Ikm4c]EGPNVIY=`j@WGONQ:Q?[h
lBa_MjB?K1oCIgU?ddV6Tbl3cIDL=>?_;=f5^QG<7==<4fFTfNi4`d@9JGhIelkU
W2S;JQiFB64g]Y:<OoPKbDF5cQn7PTZjm=d<QH9ZL`0dlG1^o47`SJcMHmZWgI?`
gQ3E7/He59mlB?`]I<b@a`ZemdP;lb=haRUP5oh@`]lLhM53Lf2G7e5MhE]9ai;i
l]jaVQA22Uj<MkhPiFoNZd;7Sd<U9Ag;`EOMj]IJo8L29>egVN_WIJiOoPF4R_3M
2VE^I7=dLVEQK@YUKVA_HVX:=B0`86mRJPXb<SLd2VE^I6mRJPXb830PKf9Z2S`l
82mDNG1U82m@HFMU82m@HG9UKW@P<b0`858P;e9ULfmeLV=ULb0f830PDR0_@fm^
M6E^M7<P=20`858P;deUI6UQ@Vmh85/`830P=C<a83<b<Ed:?Sh:IFiTKf9Z2SHP
<21_HVX:?3`P;e1bKf=CIG@PFb0_D4A682mDIGQd85dP;d=_K6mbDg1QHfDP?3`P
;d=c<B0g830PDR0n?R0_AVm^M20l?20_E5@a83PP<21B2Shn83hn2VE^I6mRJPXi
830PKf9Z2S`l82m<IFiWM6PP<C0P<21B82m>83<P;d5/M6EbKV5dIB0_A6EfJF=U
DTM282m6JFadIG8P;dI/HGAUA6ESKfAU83hn2W=dLVEQK@Yh0IfFMeACfAJ7ckdg
_M0B8R0Um1Yj2B3B>dPE1569BH1@0XJ49WI41DHD4BUFI5C00DN78V=550^3PV;G
2O8@D<K1DDA5iMf<J`W_[CGcgY[maeWOfNNgemUWkggG^P1@o884`WAH0H0dXEPD
k^_1G18CblCg0QP@0@iH0L3QIVH4AoQ40]Cl_CfIVJQ8a[?fkRj0I;_K;;m@9W?F
ognA8SM390H02TGE=San9QOU0YAC/lDI<_l4b_BE:C:6<C8FX@VR[2;Sa:m/mZOV
:k_9V9LVi:4JFLhI_3BNS;]@gYXUhJ><1:5LV2GPIj=l1fFmE4VJ0>Gg:=?Cn9a<
030DVEo<ibJQK8TbAA@IkXWb0P08U<@i_78>RoTiJ9h0N:IWi8X4RDURYQ7GV6WU
j<QVn_6cDoUR<B^D`dgQR7Q<coBd38h`5h2_KiI50BEIKIUXTNf]7>g]FMKVJ?Vo
fMlNOU?m?LQjneGa9^c?WT6<WUWOK>b/;kdF0?HTFY/M/kjEE@2dK@I0iN6/CnlP
0?850;CNW?<NQVaNT/CR32L;Rnc/K7<1Wf/^:nPgnin2KlZoQSWgVL_^neHkYQLo
PB=95C=UANFVYjI;A<c<30jGcfCmma3ohl0iJLg9`bbLWl0GlHGXEE7XU0V4RFRk
QCb1F90^I0Z4OmGQOaPf9`LIOYe[56QeG`1mQCU@^4T7b6lm04<S0bA^?gX2ON]K
434:b;jlJ:fA[g>?<W[nioXO2eb:K^5<@B9Ci_H<SfAb9J8/6J?OQ6c10Q:@1gBP
2SB1;S02;60=780cL0?N8024P4P@0iH3;TP2JD04/T4nf00:@C7H0GJ3JW00e85j
d0A>PSI`1U`4El0=L0/<P4M02XK1Bc01gX5Y28;`41FR@JZ@5Z@?VD;F41]J27U3
@E0h50?5@hV@4990nM0VZ1PZPjZQ@e0mm2=d6[X8GH?jX0O@83@6o@5mQ16H0]=Q
3MP0]X3I/3/L24O2bn14N1FL1aO0fn5:^1Hn3[O25n4Kl00/QEo2T`Q0b0P3dDIH
21_aA4:@F2@14B5[TB:T0ZU5VY0>Y1^iSDRALN@31XNQHIPH5/HIhhMIS>5REV7F
HTX`eIQSV5I<5nHfIQ0cPOV2YF;E/JIH9j`oMPTf4I^=;LAFH8mPFk2G/@?HHN`k
70k7`1WR771n^1QL<Vhe[PBg3mN<^h3[``gQ9_5h_2[N5>n23l5cl69l8Kh:Oaao
7]n?7lJo9i09FPA[PPlQUR0TK2AD41X8i`SmQ172=561Z4md8XH@NLALHRVaS]Q1
_4TL9TjC54V691MB92VI]85DBFXRGBHm9[dQTlTjI4Mb65U0GTn^99lPGbD?TSm@
U2PV54m:74E2fDhiB[U0ND1i@jEB3JQ^e5RZV;ZMFTnmA7e:OBm7Tc>GliOSbJfC
Zi5[UN^GNbE?U=NGMiMO;YlWGb5oB_jVo;P2DL50`E>1Xk1FXDKQ]<8mQDU5VZ:E
HXQRVV:9HX?R=LEA9KbBPI:g4TnY@>V`dRFU8AY2djEid[RdCK@jfVGJ<1e7=jCk
di?YaO@Oj;gd2FDUIE_U:>DLiA[U/lYB1/8`H?PcDQVUS9><^hb?lcCV^LoScm/f
[fUNok`YUOTZKRYlUB:EIYD1UHnZC5E_eACEWJY]ZToD<6XVJV5ZfF[keBj[SLnW
cgNNcieO=?oTo8OZ/;Z9N[SjJ_G3jSgZTaZJ6[hJ6AYE6YLdaSDIVVjJbI[UV^Ld
akAXFP^e15[UF^NeGS2EVNk<E6HU/h/iXJf^kJL]dCjTgJ/m[F>X/eQWXdjccQ=M
TRiK=d6gG;MCMd9?BbmH;en_DNnQ?U6O[InT_dNoFgo:`=0PfV2;@I_1Z:6:XKmQ
WV6ShF<SZY6[dBZSFZ<kaSQS]W6:lCkSFbJ`RIe9TTV=bDeCf=CNE62jckC?36_V
J2HdZcFkaj:`g5UI[4KFX3W3?<QlXgVKnB/;?H]HRidFgAIO;>d/Dbg[;1mI:ET5
F6fdj[3j`m[4VV]MHgg7QV[SHk?>Y]gV]JfY;Mmf_nem>iYM/=dF^djkcoH>mR;k
9_/a1cf7N8Nm3_OHM7HX^hAmeA7[j>6hc_6<h`LWNbNaddVWgieIcRW>3LjS2``G
l1OD;AQbdG7Q^1abTBiT;XaON72Qe5GKUN=Jjo[<CMN=igK4KLCMf3gIoKSk:`m;
3i57RlNDYi?W6/l;GXRG[eNAEjngT_MRkf[_Ychj?XTnSChC_WJnZgd_n67m0_ef
n]gceo3Wn]OkC`@h1:`9j0ZT14H4EPLn2c894PEe1<?10L6kPQl_dUlTG=@F0T;l
@gJ5?0Te35dEnW<H;R`d[2K/NKQEN7ihM`@]HTE4@lBkB8o8d/Q7RhdFBaIgA/U7
aDGEAde5NdFGAD^GF2aI/nA6S5Z<8:Hm5QlK5G/TMW:Ymm;MBhOSk>8:hnh^<ebF
/ncJL[GUZL_?[Y1O`EUa:QhK7agO4?n94l:YiDb^m5niMnD4ei>kQo^BilH[ihga
GOQUo944UhBbQ=54UlAMRF=9[TTEBN<2Cd6eh7FbGo:1i:VDT9BS:C>YdJW=JHBd
n;CC@REQR[0[GC<m9kd_`cBS<4>jbVWEkUDCXT3ATD`XLeUV^iR>oTceB8`TVbF3
F@^cJ[;NIdMUWlYAc17Vm>BJi6k;7LWcbO]n=FHeMgEW_WKnQ_c1=Ni[3Zf5eZiL
fkU>Meg1^^7e_^^?KB1]B=W`bdK;SFDKgfj:g]AAX56`_V1X/noVaT:i@U7Q_Bg>
F`i/aF`EK>gMI[>]J]^G8UkAmF;;hX[RCbGLT^_OFGeGnMg<mXC]_JGfYO]gh7H8
MmcMjK[cF9URFEkId:kPGJgUc?:Rl[NkEnbnEV5KLF0?JHmTSk@bZ;:mBZmZAmFW
jZCZPAZ?V^JmjW^gkIgJam_G_mm]Om<1S@?51chN51blOlSgD6^]@Fg5HMcQ[<??
jj;Z^[mWOemoA>e8lI7?AhE7YLO2SgGE>mCG=jPgU3K2SI;6/N=aafomh?E3Na>[
jE0cXkWh13PQ>O7RaoPOkih<?=UiRWfZjBOmWoJfd5Z:FZ7Fg=J9]Z@fJG]<NmoY
P=>M7LhM;CnKogcdS?JIV[?:Id_?TLhEW9/iWgMnlT;6QO6;RAN7>UMd?[Zdi=:M
[[2^g/^1UjmNlKUbZM^mnoaEUj]W[SUM>gfMOKg]Q_f=eQjkWYIOk7iYjKG_KKgY
L;?mU^>]S[h5ONOjGO/_g_JjONF>oidK0h/6n^h^_W_oG]`mjGgNoM47Z@mN?laj
>?eXoF?/hj8W2TlZWZXo[OgEn=MVZKgdk:3GH<ncR6N?Q[Q3;onEnJm?``G?ZLl[
A[A6jTN]Aln<nHcMN[7daO3;S9OChhFo:OjfmiGAZimnMo^mIf;9a?1[dN^I?d[N
Z;hin]KfKNMTj>CCMfW_YZN:gZ^n?oJ1oJ7kHoC7TNW/CoQ?UIn=?gMl2OcbN2I]
I^KOmhCcn`YUKVAcM79UHFd:IFiTKf9Z2S4`830PKf9Z2S8f<C8:IFiTKf9Z2SLP
<21_HVX:Fb0_BD=3@V5cIF@P>B0`858PG@YUKVA_HVX:<b0`86mRJPXl?20_E7U`
IB0_D65WIG<P;deUI6UQ@Vmh85/`830P=C<a83<b<EdP;d=_MFid834P;d]YI7<P
Fb0b830PDR1M83hn2VE^I6mRJPXa<B0`86mRJPXl?20_E7U`IB0_@f5dHFa_Ib0_
D65WIG<P<b0`858P?Sh:IFiTKf9Z2SPP<21_HVX:?3`P;eAiL6DP;dI_KW@P;e=e
HWAiL6DP;eAbMFEDNG1U82m2HG=UAVm^M20_B5QCB5Y=:dQUK7IUM6USHB0_AVm^
M4AULf=bJG1dKg8:<C8P<21B82m5KV=_I6U^Ib0_CF5SDVm]HFi5KV=_I6U^Ib0_
AVUbLgA3J65b83@i82m<HG=d@fQQLR0i>B0_EfUTM6Qc85/P=CDf2SDe=R0e=CHP
=CDf83De=R0e=CHP<20`830P<20`830P<20`830P<20f=SLP=SHg83Lb<R0g<S8P
=SHg83Ha<B0`830P<20`830:<20`830P=cLh83Hf=b0`830P<20`830P<20`830P
<20`830P<20`830P<20`83De=R0e=CHP=C0`85dP?Sh:IFiTKf9Z2S4b830PKf9Z
2S`l82mDNG1U82m6KfidA6EcHg9YL7A_LR0_AVm^M4iQKFDP;dQHDdQJCB]8IFaf
IGAYHf4P;dI/HFMc83<b82m6Kfid@T9_N21K;CTe<B0]=3Pa834d=3DP<C4b<Ud:
;dUdHFaYHd5^IfaU830P;d5cHfE^M20g=c0P;dAULf=UKW@P;C8c<20_@f5`B6EY
IfQd83La=b0_DgAUKEHP>CPP;eQ8IFUWJ7@:=C8c82mCM6E]B20h=B0_@GIWEfUT
M6PP=3@a82m=HGQGJFAdJ20a=C0`82m6KfidAVU/IC8P<C<P<21B83hn2VE^I6mR
JPXa<b0`86mRJPXl?20_C6E^IgAX834d830PDR0_C6E^IgAX<B0i=S8d82m6JFad
IG8P;dI/HGAUA6ESKfAU83hn2W=dLVEQK@Yh0KeJNgaDaODoLamkkcjBk2_IAoJI
cCkb8VA3@T8RFD9N?18SlI550PT@3144NDBQPP51821ETD11DEY5@31;@5e0:6;h
PKoj`5ZeDVZeP_EGVhnf1J]0MWmWkXH8ZOG37gjjmg=Vi/c<WCWc?FO>?>h^V;N`
6N:P7ERXWMPdM`I8_mA<039[f^bV^C5NN`GSYM?J5SQR?>l3H6O=V7_Gk1P_?P6P
/=heJe7onkYW0MBFU^JVjK5bX>oW]f16S2O3<4i]VKgPoQR_?H1aeJ`ido[;M@lP
kiWMM7moog0FNLLmCK>KHoECAHaCiljI_b36^hiQG3EgGW=oOE:?l[d317>el3S8
hFh@P04e?Pd0`QL::g1HB/_aEm?aj[HY2LDG@D>K1IQBoG<Yo_34c^GO=Uoa:QlC
_l<<nMGj=9JUAM80E0C;NiF?3IA8kf6P3D=MAQS689DPiB5UI8`b@S_I0HlR?H?4
`Tbb5QHQ[D7j1A8gT=Z5g46b]Y/C0hO88S2C/@4UIkmEKk8K5D[kKl=4MV2KoB?S
IhN92KGg:C5eah5lU88l@ij6jF0Wch6K;8HZl94]nm=VfA^aJ1O<AFY7HZF@T5gM
=[om:<T4=dO`7@oH>?:boBliFOKc>F66M=^?Nl<LAZoIT0/Tf8mI]mUoKKg;OQCY
QESAkSB/lK9mUgFFOH<]C;IdfangQPVnleP/FVS5Eenfcdk[]4o?TL[7MhJI5k[]
QEQnNd1Ycbm`f_>/incIg[18T<nbS[NWikaUClDG/IX36gD7=7J;MH=m11KI[>GN
4DR7bFjb5M;9eVkgF?/QC>9`mhm9:nP<Tio][o;U^<=TLB2ob]NIE^EeYhfg^m<Z
_5i<ggi:F27L:H`Bo4:6h1<lPU=85_BREUB;lJ9:E8RR:8C9W^hB^n``N@5:49HG
mX/bT@nC5c6C>dcfBYUkGa4iTA51e8NSWj3a4]27b@/7e3B5RIMUDTXF9W_gak;f
1^`LCG5BPIZQJ@``18J838b547TT;8>EBFdUaQ;]B4eQAMUo2QZUTZ]QaWon6HTe
e3V^[SjdfaX<nFTRJPeN[FjlV_R?lH:5F=ALVY4aK/:RoFecFfND=k_:6egUcDR=
XKE];LI@neB7Heo[G5[P2;6NaZWCFVSLe1bJjfX^2kFjbQckfZCg1QG?X<E][[9m
<:?le_Ym<`;=IMe]PKIbEe=IL?oDdWT=eoFeIZ2_NJDod5LYKF`NkF^Zm=jP_QYX
lECJE`?]Zh7f=CD`ENZ;3[ilIUgYo0EXWHkbVN<L8EmMJ<`]4n]3SZIPFIS/`<bb
QL0O0cEo17al>iRiK;03A3m2>T?Sb6gAcoVCX8k<S_jM;D:U7ZC4A4Z:hAPl0U^Q
2fB`4m<nV0bKh@gBRW=k4Qb03hP=QZ3_iB0<hn5=4Xfn2c?PFJbo08k3A]P7:WaW
=RARjG[RSRi6?X3YZK0RnT]8Q@9h68i08KJj7WZS^j;k/G@2g0Jkh@ElocO4aNcS
M=4GXnM0Q5^`cAEHlVidO;@;_F8VU48]iZj0XlC=WXVfP16:D;XWhFWH3Zo1glQb
LR3J4Vf;WXinRZIZ10_DhK>4722O/UgL`m4WXgn=AQ097jAS[hf`0Gj5kGOQL`aM
JcViVb`P6lQ69/0/I`i`:gU3Y0maB8=:O:YP3Za610i23o`3_R=O<DIFcBiPCdCc
X_l49Hc3DM:A=4<K?Z_`FHmS>TaTI2PICF[94_84fDSNHm:IfiQjiSkVO^Ic]XJM
a2iRgn?VLmgl>WjcC1Vi63dL?AUm7`aPQC]Q7Rc5dAf7dg01;Q4Ffk8@=bTRYF@b
?^eT:g>@K2L7VEYbS9aVMY<oTLo8En@b`c<Z9Y79H1H`6iPGV>?<fna<MR?k2oI?
k4E^9<o`foWc<[O`QlSDb9[8fm6Rj:OAKm75R^14cIA23Db19Qc]G1P63n8Xm^;C
QE[[PA?`Q_AlARc@2mlR2T2da4clY1ZO6W8cVD5VTVgT43i79EVnHE0AS9cA<0K6
`]@aDiWIC3_c?]?>9[?Yk5Qf8]^5cbWf0oHbNiWS>AfGb5EbHf0M=i_KP/l>KROG
cKg35o8SnA[nM[jMGl>_HjOako8Ob9K:e/^jIEo9_TJg>5jH8ja3kKb1=_/Jf_;g
?hjTX_An^0NVTC8b5CYA6m]94gBPMDdWZa6_^N2;=[1;fDYV:5[3DOPIF^/FF09[
f4V`?OYkMSMlR9Hb2i]/QnNiD[3bVe0kbf4XFU7o4dQ;Co=i?NiDEh[CPBkOTV`f
6@e9RGZMEZ>>DbTELU6@lAc;4<P/MeDd>T:NaQ3WLEEEIE7NeH@ICMMT=>9DMX@Z
[ZlCL]3gV[3X^YX1[3USD<e0[6IPX2IA>hZQ>2_CDNibQ=hZLcW2I>8]mIQnY<`E
M8AjYGBeU7iDB/MQf^W45acUaYHbAhPd>/Y35Fd]7NF=IEVIi600hE1TIE;74@0U
KCP4Xi^FX8>5dKA6NLS/:R/?VEbHaS;FGMhd?EAkBgeiFK;C6L@lc9Y@SgeTILh<
XIb`ESGM=Ge]>01C6fVZJE9mR6d:QYQ6fYHV8fA`UHD<RllK_fN_Y/[GGE<HH]`E
CLdM5J50heX4Uk:=U6]JQmbh>PLfbj`<eXO8bWhQZ8b]:2TE=kHV^1]K7B6iZmCE
d]7JR>32Q?Y^Ll0/>Ml@e=IgV`8VRLW:?6QLF^C4dAo<6YDeR/I5C^?BF?bGQf;i
_ce6Hn?BWTl`7SMQ00124G2=@CU3SVUB9bhD]X06c@G@<Jd0LL9OT>0`Ij8lXd<<
fPc[3_7^<DfQm[Z[H[BDaHA[K2g[UY_<dR9D6/CjSAgZ4JPY[:mf>CX^hV[Mj>[m
foDiCOdi<[Oj8]12Z^P1F`VAYZ_Y=[YH^W7D;DIG2mE_VjACi5g6lV/bT:O@D9U3
NUc0Jn^M8DL@<g0gVCT^3?;JnWf4[0n6BGAU6<Z/1g6?bTjIS<FIe=AVUV7ob6AU
HTJj4e=3<QdEf7<5]AE7Qj=Sc?@>AhFS1Hf9Ld/a5SAg1;<A`KYja0U^aAh3`NB1
I7<`>0;KbJK]h2]H_B>8;KCf]h2aU9GMQiF6I^9RbWYZjfnY3kFG9HL2ID7D0Y[_
/M[jd36dg60@JnD<B8XB;iUYk9OISc;WY6=iKZ`Eg;^dHa?1SPkJIUfmbaTje]6A
g47WFh`?4aRL4NS?20>]@R4?ToIJO1LSUc=IdX7CiDBaPQCCHFSBEbd:mn`oSW3n
P=chiW2D=Um2^>0W@[S`AQ0NLD<85`e8NQg2aBQc4DGhY_lN`R>_@kSTaa4>3<R=
@Xi2J@<B`ZDo4L:SK`CQ/Q]2^7a0d^/@[T2IbbW2UOlmQ:^^@gS<Sb<lMT1^578L
BS]F@WSlChA`mHdPG7=32=ll8>Ue2=NRc3MCQ6oikb4lhCZ4jghLhE/7i4HQKd=Y
KiD@__dW@_R>6d6hoXH@3Pi8NQg24e7V84GhcP640lTQ^=H?]`mb^o2C>nI9ed2>
>bEN2jGLO>Q12R3U80e3XWWEo>eP@mZ4ik69B<mQ^X_k3;YTQE0[YNO31:cGQXMa
NU:kNPNT`Y<9_C_:PEcYH<kRVHc7_1oj2KRgUh<2CbVZOb^>PoQoba^LTH2gD9[n
c7bH15oPFNK?C1^[HSMc5Vh?7lm?h5O865VmT2:/4fUk39hSP3^=idlFkk56anjF
a>``L4RR>Pa`6XWbV6K?HQYS0F<FHoUI>8A_0MbNL@QKhS4NVY>[LFZlB:GLn_2E
?o=7;Xd>LmFGlJh2Amn37Kk??hjSM>dCBIST1U@L9jPhXI<7AJELgMISk7Vo[a1:
BRjlUC=DUcNB3<oE^3@m[foa[3o6O]>Q2njhM0okSMAF0>FflDm12^`8e>Ac5M`M
o=gFNfb;KB_8:TI<5bNJkSHmH7[0lY:9QaBB`5WRCDk1H/;k:=jNT92RDnCYN8Mm
XC=5iGa@:4RJTa;_CEQV;dQ9[GAA>GkGNj5GOK7g79@DmaFGm6ZdQMUJ@b71F5]H
Z<406W:6SUhD/70VUE_SDF[SOB3G2ciRh^;D2QlA4c70VcVeV]2;P6G@T:l]8OW3
lo>6NE`YPTa`HM[YebKZ1ET2TF66<m4iM^E[aiH=Vm2ii62UQg^5;Ee8O=ml]ZSR
YCEC2jJKfOP[J@N9M^jLLGUeMboI/6kLb/=]Yb?Oo6[?h/[VlOTiMkC^UW39RGk4
VOT]J6lm0O/HEEeFLmZd[8EY2k=TWAhbC/a@63?dLNag>OZl>3aL^09jCIkj`KRh
W>BlE5k8bhTcMW[;=66l5Da@50bI`mSC7<]H;i=KjKl65L@6BWY;NQ6D2gfOZg_E
51n:S@A9O_I@T`OT_<OZC_78P?D1ahY34@j;bnh3/m_X8a`A4:i/36c>I<C<P`62
UI51`E8GdmBbIHPIJN2H_=`T@e:^?`JLC<RcTEco=C0>Xc3R2@hA]954?KQ8d_UG
EKj:EmK_NFVkeZfcN9:JAlgKg7bPg<=g1nhQRGoh^S:ch]h78ooheT/<YmJFg;_i
oROJ27VJIA`5Smjmh?kBaLo<?OGj`ADCLZgfONe_AB88:eXggR]cfObCV8Z3BH4D
>J<@h`S37=G:I08S8k`Ph[UOD30;UOaG[4[Pf30a_4@jhl@mRS2YgllWE<I;25jl
D=b7EUF2DK6VD48=PB]L=BB3Fj8nTI0cU6STA>?<8kVJg4BGQWT^TTONkU_7?;[i
_OO`bV1=ggdAWT`>/N^_C7TZlT/Z6h7Bj5W>P_M73SPLb:SB[[HcQJX:gAfj^gCL
254E9h1:TA0O_e2[dfWS4aaJW@0jPl:@Qh:U1<aa3lK7FkDS4SP^cg7B6ZLA2/ac
X<2AD^V<JOaRK`lZ^kNT3kEmk/9ECM=YP3:Sb11C?N[NR??1Ik@C>N=QKGQiPeNo
3]j2Ld9^a83H>Ao8TS4@CK6i@KF];ZKZY[Y^d5fWIjl>9`B;TbCGcbGZ6FM:Z[M?
^bA`jc=KGVU_F9Wmi6cVRkjWKo9WeLhl@KBG8keMTGnZbN`]AKHg7nQl]RXPImTG
8o<l>VOTmMm4o_O4Vi8>Zj=oh5cl=TP6;n`:5=iW9PKA;GY=mJJ7HAEI;ALZAHGC
jlb;SmNc9hFlI=jKQg<USEUV:m3<<BRHHTEZSR6]dRL1deOh`;P9mbo>=Z:Kj9l?
M49@P:AY<<c]/CPBTT36Na`9=Qoa9:Kj`:;359dCQ6?]JZN?^9>l?[1Z<J1c@_8E
93H1j0aHAQ[`/d9BX/_SAJo1O0n7:`Ddj^5JYkIoFRCZTg;IbR?MJ]NX5I^j5B<W
gmijP:PRGkhA>C]Z2AVok96U>aId?Od8_nfk5KL=WASi_lRE>k=lWimk?O8NbL6[
8>DQ<_gB7gnmo9jCFkJ^YWN<;=Q`=K`9e`E6FXo>16Z[B3eY8NaZMQ>gFK5;4IJ7
5C:OPX0PTa56U</aD830TgF4iAajQL:]aC`mck]aQQ2UTVOU2Tk64bE3F61/PQPV
`H0L[eYTLPG;8kLcX8f;<aS<o3JbCF5BaFeg[Y^<=lVVVP_6j[hnDdeiLmWW5FE6
:34DUaAGmdWCYh@jWIQ7cYJ/LAbN2;USbB6^9kQZR17=TfJ`V<7f13?jjjiB5aL;
B3SE6Q1NXRBjG>9RWJb;/>_oe;_bDbKac<Jn`dnobCc:C:@CSYefJC@9AjZTEG8C
h/9QBX5gYciH7RRH63MAdlZda[EZ5S?g>HDaLEDJaR[J4cRk3S7dRSH3XkAiABhW
NFI2S/^L;Tmdni9<JNUQ<VFo/fd63[7V0Qe?SOZKJ/V@nRC7f_Nm@mDJcKaXL//l
PY7;8;aIc41WBDf5fTL3TK`QfXMCLdfBMC[X_AIjAIaE=4hSC<oBRW/FURj??4Gf
_U:Clo?aBb8;GfO^8lc/`<eYeOLFC0^^S7cL]h6]M@gonJ=nBjB`Kf;[j2W?S;3g
GNIeFnjlKfd`fi^AgkQ[oO`mJ1DCXfOhNoWcH4E;fALXB^HgTDjN]N</GdiFlF]d
O9g8?VcEJ19U8jb/JTBRg<KHK2HfQbUBifS<3WV>bFAgK7NfaP2Xk^dO?/hPM8ja
]DGM:dfT4F0a^7FNN7NbAiTTmd>LG^dWFTf2F[0Pa`?[9hCQF8EAiHL4;@JRFNK7
9@H3^Y3PM:8C:QKBS6Fh[8S4h1Y2Y5VTYL_9l5aLPYd>[`MWEKkCaMW8<<eaihW^
Sb8GookEfOTgfHjK7nn:O1R55lo_>D@ZOOcib9W3jgM4gXVLR4@R_mhEO>b;Yhi/
OH_/8NFWobciV^O@CZJQWLCQoOIM0O/ZCJNFlH]:F`83=X<Xi^S<iSQg_<UTo/3I
]THbP^Xn2@<XjB_YT`K^8DTJMj979_029k028o0bQE[4dBIQ8=LZoDC@hhfY]6ZV
dg6ijDSX7T?=X3E89Z3A2`bZoWCcZ0ESRl`97odml_@YYXiT?knaOV_ThKj^gHWN
>L6eMIE4@hILg/c[?S`NNON_Ab;MdQRjL<g[aC7@oFQ=85F`LIbB]N7W9KUXDbQ5
5J=B<B2KbAC9cO6/j0ICG7bH:?Lk=ehMT6CD5lkQa:=JYC^YH^XSLGSD^f_jRGAa
fELf/1UGgVLO^7bL/O=73TA:MdOR^k1[o16l5`I^=c9b:0`HZACbORUTMa>cD^YI
X@bC>k3W/oe@BSgCMOKO>WAe/IN__<VlfiMmD^ZXZfljmGNedOOi;m2N4g1e/417
87<EK_9?T]NIDn8K2]UX<G540Y/l@Y1K68]5ZLeQcCISS]9T]OenT0T?6;2T@SnH
hcc4;GOcWZAhXaodX?DC/hPY]@aC1UFRWnPH34b:I3mX>0`TVjD1oN6j28HTSEYP
nXeCj`A]WQZXiNZeCYKKN_Saig/R6b=kSnmmhRQn5TWn<_;g;lm5?_TGBHcWcemj
?G8jl/ZI:7cbNc:FY?n>Z2omTRbjR9lXRR<W8nmLR>cS9n=LY_QnRoPZD;jV@=i<
eDc]8]ER;ENU[mNgj1O[>D6dJMAZ1HU?X=YGR8a<Zn;TNWd>Idi:T:?R4i=n@?5m
6]`baoB^AUQ@o@@gc@djJKlV@`]ePNBfW;Rijf8fmWcm`LLAodVfoOkBnI45I=g3
co=7oWQZCkA_0gM`Q3g2cW^DjVT2kWGXUhL4?6DE`al31NU3RD:]C5II_;UEjYWb
E[E@:6YELSKI;jC:[FZE]BR36I9Fm4XADnA?Mf_E0RmJ_2T6BiQd15`6Zeg`FXLX
6F^N/UPX;[KXQKCdWJWVTLUYU[49gP;CCB=O9I_`Pl]1dPTadd8OCNOY^KjN0EGS
mTQKB0OKP9HnY7M8;efF=8KH?/2G?c`a1HS9CO8CW62d9C/QbJ5g4VL:36NLH;HJ
W2CAR@7EO?oJgkoiCLEmko3lVdPlTHh8RMNM7dKR?QQM^`IGOSmf4HoNc>_ad/RC
=bao^8k4cj^I4^ad]_QWClfY8`M69ZXNF_a8TE>aTooG[hjd;CBhECI=NZJW8Ce9
?_c]1cHN>KBYhif9VF=f?9IXTLG7FK;_8[?4C6?FY;[ajGGo/kFZJW?O9T/:bjiD
bDYMPJ[FUeI_O5I7c]6mLE_dHlk=7lNcY`gV1XK/49jgO6QQDl@46l<36:blX57H
[4ZUgR^J7NHQjR4T3CCXoULiScALGOo>WN_gO[gDoF_`S2E=8:<fBJI8T^TmA:_0
854`N8Q>K_?4_1kM=nYb=A@:[DK?B0PT^U87=TEhL6S[:WZflMAggiaIO:^oL0Lc
hk777_WI@DoULOihgiOE]dAj8aLRTE2AZg[=TRn>k_[hiGLgCMhWnCklf/JNiV[0
S?kPnD3flbJbfKQCg6eTahZJ[GZFeL^/IR7>ZULV2lW91[EGBo2HY35K5Ej3bH9o
@A3f>nL]jKLH75UaMFmQ8OEmPeNgHF0BgJY4Q@ORMFXL9EgGC<SQ^^JDeSEUDY`7
ecD<i4JIQji[cQmHea08g2/VaEHe@DKgPfPE^M@L6?@G^@;c`FN6;_FlYG_63Ugm
n=b7C5ff[`oomQ;Ao/k2eH@nW?K@c]W?K3nki[kgCi3Lco5Ch@PNmB[mX/gh[OB7
OU[<e><^:0VoPQ[1Q5n=gN31WKD?_lCjlKJS3<ZQ@WZAh5MQ8ZETN4<1EOEeEA>[
<jZJIkDe;iPi[@U;HZFdBRgB92Cj7HonEfLMdY=8Ni1NAJ8knK=8Od>jPRnZT2a8
VDS5B>>A9TGkOeP71]84clCGloi1O>hP7/mlekfO=hS?7lB?6/BG3^973n;;1_7U
PgP9_F_T_gU@>LGZf_5A9:oUY`kRYe7no`6Nkom=2VE^I7=dLVEQK@YUKVA_HVX:
<C@P<21_HVX:=S4i=PYUKVA_HVX:<CDP<21_HVX::6eQHdmC85IULW=YKfhP<C0^
<C@^=R1L:49eJFaT834hAcPgG2TPDGEQLWAj8514AT=_KWAUN7@Y2VE^I6mRJPXa
=R0`86mRJPXXA3Xb<34i<3Pb=S8`<3Pb=5X`<2L`<2LY2VE^I6mRJPXa830PKf9Z
2S`l82m@LVmTMF=ULR0a=B0`858P;d=bIF5dJFm^A65dIB0a=R0`858P;de_I4AQ
M6DP<CHP<21B83hn2VE^I6mRJPYhLVEV2S0P<CL:<30`<30`<30`<20f=CDc=B1V
80X`<30`<34b=3Lc830`<30`86hP2S0`<30`<38c>C0P<30`<30PKR0:<30`<30`
=C<f<B0`<30`<21^80X`<30`<30`<38b830`<30`86hP2S0`<30`<38c=c0P<30`
<30PKR0:<30`<30`<S@i=20`<30`<21^80X`<30`<30e<c8f830`<30`86hP2S0`
<30`<3Dd>C@P<30`<30PKR0:<30`<30`<SDi<B0`<30`<21^80X`<30`<30e<c0e
830`<30`86hP2S0`<30`<3Dd=3@P<30`<30PKR0:<30`<30`=CP`<20`<30`<21^
80X`<30`<30f<3D`830`<30`86hP2S0`<30`<C8c<cHP<30`<30PKR0:<30`<30a
<S<e=b0`<30`<21^80X`<30`<34b=3<a830`<30`86hP2WAbHFU/IG8:?3`P;e=Y
NVDP<CLP;e9_Kg@P<C4P<21B82m9KVI_834P<21B82m9A21K83`a=VDi=c4a=3D`
HSMT=S@i=STfHC0a=CP`<6=SHCLhISh:?34fICTg<C4d=C1R=f@f=3Tf>CIQ<34e
>30`Hf=Q=cQV?R1M83hn2W=dHG9dN79UIPXa<SDd>0XU9DE?APX\>"], "Graphics",
  ImageSize->{281.4296875, 170.1298110875706},
  ImageMargins->0,ExpressionUUID->"5f81aed6-adb1-47c5-b0f3-5ff88172bbaa"]
}], "Graphics",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 CellChangeTimes->{{3.775838924268386*^9, 3.7758389379704847`*^9}},
 ImageSize->{289.19140625, 200.80931355337077`},
 ImageMargins->0,ExpressionUUID->"fecae20d-e830-4536-91e9-f1518edd81be"]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", 
   RowBox[{"a1", ",", "a2", ",", "b1", ",", "b2", ",", "c1", ",", "c2"}], 
   "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"AD", "=", 
   RowBox[{"Stewart", "[", 
    RowBox[{
     RowBox[{"c1", "+", "c2"}], ",", 
     RowBox[{"b1", "+", "b2"}], ",", "a1", ",", "a2"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"BE", "=", 
   RowBox[{"Stewart", "[", 
    RowBox[{
     RowBox[{"a1", "+", "a2"}], ",", 
     RowBox[{"c1", "+", "c2"}], ",", "b1", ",", "b2"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"CF", "=", 
   RowBox[{"Stewart", "[", 
    RowBox[{
     RowBox[{"b1", "+", "b2"}], ",", 
     RowBox[{"a1", "+", "a2"}], ",", "c1", ",", "c2"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"AP", ",", "PD"}], "}"}], "=", 
   RowBox[{"VanAubel", "[", 
    RowBox[{"c1", ",", "c2", ",", "b2", ",", "b1", ",", "AD"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"BP", ",", "PE"}], "}"}], "=", 
   RowBox[{"VanAubel", "[", 
    RowBox[{"a1", ",", "a2", ",", "c2", ",", "c1", ",", "BE"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"CP", ",", "PF"}], "}"}], "=", 
   RowBox[{"VanAubel", "[", 
    RowBox[{"b1", ",", "b2", ",", "a2", ",", "a1", ",", "CF"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"s1", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"a1", "+", "PD", "+", "BP"}], ")"}], "/", "2"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"s2", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"a2", "+", "PD", "+", "CP"}], ")"}], "/", "2"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"s3", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"b1", "+", "PE", "+", "CP"}], ")"}], "/", "2"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"s4", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"b2", "+", "PE", "+", "AP"}], ")"}], "/", "2"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"s5", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"c1", "+", "PF", "+", "AP"}], ")"}], "/", "2"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"s6", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"c2", "+", "PF", "+", "BP"}], ")"}], "/", "2"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"K1", "=", 
   RowBox[{"Heron", "[", 
    RowBox[{"a1", ",", "PD", ",", "BP"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"K2", "=", 
   RowBox[{"Heron", "[", 
    RowBox[{"a2", ",", "PD", ",", "CP"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"K3", "=", 
   RowBox[{"Heron", "[", 
    RowBox[{"b1", ",", "PE", ",", "CP"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"K4", "=", 
   RowBox[{"Heron", "[", 
    RowBox[{"b2", ",", "PE", ",", "AP"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"K5", "=", 
   RowBox[{"Heron", "[", 
    RowBox[{"c1", ",", "PF", ",", "AP"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"K6", "=", 
   RowBox[{"Heron", "[", 
    RowBox[{"c2", ",", "PF", ",", "BP"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"r1", "=", 
   RowBox[{"K1", "/", "s1"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"r2", "=", 
   RowBox[{"K2", "/", "s2"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"r3", "=", 
   RowBox[{"K3", "/", "s3"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"r4", "=", 
   RowBox[{"K4", "/", "s4"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"r5", "=", 
   RowBox[{"K5", "/", "s5"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"r6", "=", 
   RowBox[{"K6", "/", "s6"}]}], ";"}]}], "Input",
 CellChangeTimes->{
  3.775663478246791*^9, {3.775663522757359*^9, 3.775663602829411*^9}, 
   3.775663685895385*^9, 3.7756637665027943`*^9, {3.775663835783164*^9, 
   3.775663845437812*^9}, {3.7756639160963087`*^9, 3.775663939454138*^9}, {
   3.7756641766406403`*^9, 3.775664250631572*^9}, {3.775664284727785*^9, 
   3.7756642998066273`*^9}, {3.775664506841662*^9, 3.775664509647408*^9}, {
   3.775840026070065*^9, 3.775840038413294*^9}, {3.775840136038224*^9, 
   3.7758402568292723`*^9}, {3.775840287533717*^9, 3.775840464477415*^9}},
 CellLabel->"In[4]:=",ExpressionUUID->"243d8d3b-c993-4e0d-a31b-d158b3681dd9"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"TestP", "[", 
    RowBox[{"na1_", ",", "na2_", ",", "nb1_", ",", "nc1_", ",", "nc2_"}], 
    "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{"Use", " ", 
       RowBox[{"Ceva", "'"}], "s", " ", "Theorem", " ", "to", " ", "ensure", 
       " ", "that", " ", "the", " ", "three", " ", "cevians", " ", "concur"}],
       " ", "*)"}], "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"nb2", "=", 
       RowBox[{"na1", " ", "nb1", " ", 
        RowBox[{"nc1", "/", 
         RowBox[{"(", 
          RowBox[{"na2", " ", "nc2"}], ")"}]}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "nr1", ",", "nr2", ",", "nr3", ",", "nr4", ",", "nr5", ",", "nr6"}], 
        "}"}], "=", 
       RowBox[{"N", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"{", 
           RowBox[{
           "r1", ",", "r2", ",", "r3", ",", "r4", ",", "r5", ",", "r6"}], 
           "}"}], "/.", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"c1", "\[Rule]", "nc1"}], ",", 
            RowBox[{"c2", "\[Rule]", "nc2"}], ",", 
            RowBox[{"a1", "\[Rule]", "na1"}], ",", 
            RowBox[{"a2", "\[Rule]", "na2"}], ",", 
            RowBox[{"b1", "\[Rule]", "nb1"}], ",", 
            RowBox[{"b2", "\[Rule]", "nb2"}]}], "}"}]}], ",", "50"}], "]"}]}],
       ";", "\[IndentingNewLine]", 
      RowBox[{"For", "[", 
       RowBox[{
        RowBox[{"t", "=", 
         RowBox[{"-", "6"}]}], ",", 
        RowBox[{"t", "\[LessEqual]", "6"}], ",", 
        RowBox[{"t", "++"}], ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"t", "\[Equal]", "0"}], ",", 
           RowBox[{"Continue", "[", "]"}]}], "]"}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"ans", "=", 
          RowBox[{"Quiet", "[", 
           RowBox[{"FindIntegerNullVector", "[", 
            RowBox[{
             RowBox[{"N", "[", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"nr1", "^", "t"}], ",", 
                 RowBox[{"nr2", "^", "t"}], ",", 
                 RowBox[{"nr3", "^", "t"}], ",", 
                 RowBox[{"nr4", "^", "t"}], ",", 
                 RowBox[{"nr5", "^", "t"}], ",", 
                 RowBox[{"nr6", "^", "t"}]}], "}"}], ",", "50"}], "]"}], ",", 
             "200"}], "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"Head", "[", "ans", "]"}], "=!=", 
            "FindIntegerNullVector"}], ",", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"Print", "[", 
             RowBox[{
             "\"\<t=\>\"", ",", "t", ",", "\"\<, b2=\>\"", ",", "nb2", ",", 
              "\"\<  \>\"", ",", "ans"}], "]"}], ";"}]}], 
          "\[IndentingNewLine]", "]"}], ";"}]}], "\[IndentingNewLine]", "]"}],
       ";"}]}], "\[IndentingNewLine]", "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.775840748673451*^9, 3.775840943686553*^9}, {
   3.775841107345518*^9, 3.775841125871274*^9}, {3.775841160935998*^9, 
   3.775841180199389*^9}, 3.775841702921143*^9, {3.775841815969596*^9, 
   3.775841832889604*^9}, {3.7758419037775593`*^9, 3.775841927817391*^9}},
 CellLabel->"In[29]:=",ExpressionUUID->"ecd911d6-08ee-48a1-b698-fd4effacd353"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TestP", "[", 
  RowBox[{"11", ",", "3", ",", "7", ",", "5", ",", "13"}], "]"}]], "Input",
 CellChangeTimes->{{3.775841140991435*^9, 3.775841151510344*^9}},
 CellLabel->"In[30]:=",ExpressionUUID->"318f716f-b1d9-4b24-9d97-87b346cce7b8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"t=\"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "1"}], "\[InvisibleSpace]", "\<\", b2=\"\>", 
   "\[InvisibleSpace]", 
   FractionBox["385", "39"], "\[InvisibleSpace]", "\<\"  \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "39"}], ",", "39", ",", 
     RowBox[{"-", "15"}], ",", "15", ",", 
     RowBox[{"-", "55"}], ",", "55"}], "}"}]}],
  SequenceForm["t=", -1, ", b2=", 
   Rational[385, 39], "  ", {-39, 39, -15, 15, -55, 55}],
  Editable->False]], "Print",
 CellChangeTimes->{{3.775841168998485*^9, 3.775841186074671*^9}, 
   3.775841499422229*^9, 3.7758417507594147`*^9, {3.77584188462199*^9, 
   3.775841931798087*^9}, 3.775842242979396*^9},
 CellLabel->
  "During evaluation of \
In[30]:=",ExpressionUUID->"d7ab947f-992c-4205-8cc7-e69cf826a92c"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TestP", "[", 
  RowBox[{"11", ",", "3", ",", "8", ",", "5", ",", "13"}], "]"}]], "Input",
 CellChangeTimes->{
  3.775842063512344*^9, {3.775842121921644*^9, 3.775842136752356*^9}},
 CellLabel->"In[31]:=",ExpressionUUID->"8da35414-adf3-4a38-9302-92f563c14af4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"t=\"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "1"}], "\[InvisibleSpace]", "\<\", b2=\"\>", 
   "\[InvisibleSpace]", 
   FractionBox["440", "39"], "\[InvisibleSpace]", "\<\"  \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "39"}], ",", "39", ",", 
     RowBox[{"-", "15"}], ",", "15", ",", 
     RowBox[{"-", "55"}], ",", "55"}], "}"}]}],
  SequenceForm["t=", -1, ", b2=", 
   Rational[440, 39], "  ", {-39, 39, -15, 15, -55, 55}],
  Editable->False]], "Print",
 CellChangeTimes->{3.7758420642404737`*^9, 3.775842137356983*^9, 
  3.775842245835498*^9},
 CellLabel->
  "During evaluation of \
In[31]:=",ExpressionUUID->"2141bdc8-08c2-4cfc-941e-d5e8f29cc516"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TestP", "[", 
  RowBox[{"11", ",", "3", ",", "9", ",", "5", ",", "13"}], "]"}]], "Input",
 CellChangeTimes->{
  3.775842070040427*^9, {3.77584212470553*^9, 3.7758421412002153`*^9}},
 CellLabel->"In[32]:=",ExpressionUUID->"54eb1bba-5cf1-4f8d-a8ae-d34645b089f9"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"t=\"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "1"}], "\[InvisibleSpace]", "\<\", b2=\"\>", 
   "\[InvisibleSpace]", 
   FractionBox["165", "13"], "\[InvisibleSpace]", "\<\"  \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"39", ",", 
     RowBox[{"-", "39"}], ",", "15", ",", 
     RowBox[{"-", "15"}], ",", "55", ",", 
     RowBox[{"-", "55"}]}], "}"}]}],
  SequenceForm["t=", -1, ", b2=", 
   Rational[165, 13], "  ", {39, -39, 15, -15, 55, -55}],
  Editable->False]], "Print",
 CellChangeTimes->{3.775842070927658*^9, 3.7758421417984333`*^9, 
  3.775842248506768*^9},
 CellLabel->
  "During evaluation of \
In[32]:=",ExpressionUUID->"ab5d1008-2296-4504-b89d-14aa234561dc"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TestP", "[", 
  RowBox[{"11", ",", "3", ",", "10", ",", "5", ",", "13"}], "]"}]], "Input",
 CellChangeTimes->{
  3.775842081056319*^9, {3.7758421282893543`*^9, 3.775842146672106*^9}},
 CellLabel->"In[33]:=",ExpressionUUID->"0d96ca8e-e1b0-4301-9588-931caa645e0b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"t=\"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "1"}], "\[InvisibleSpace]", "\<\", b2=\"\>", 
   "\[InvisibleSpace]", 
   FractionBox["550", "39"], "\[InvisibleSpace]", "\<\"  \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"39", ",", 
     RowBox[{"-", "39"}], ",", "15", ",", 
     RowBox[{"-", "15"}], ",", "55", ",", 
     RowBox[{"-", "55"}]}], "}"}]}],
  SequenceForm["t=", -1, ", b2=", 
   Rational[550, 39], "  ", {39, -39, 15, -15, 55, -55}],
  Editable->False]], "Print",
 CellChangeTimes->{3.775842081905531*^9, 3.77584214782231*^9, 
  3.7758422546173687`*^9},
 CellLabel->
  "During evaluation of \
In[33]:=",ExpressionUUID->"ad0e94f5-2a0e-43cb-8f8c-f3719b998c5e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TestP", "[", 
  RowBox[{"11", ",", "3", ",", "17", ",", "5", ",", "13"}], "]"}]], "Input",
 CellChangeTimes->{3.775842161808625*^9},
 CellLabel->"In[34]:=",ExpressionUUID->"a37ed5ea-93d6-43eb-9c89-cb07df1ac960"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"t=\"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "1"}], "\[InvisibleSpace]", "\<\", b2=\"\>", 
   "\[InvisibleSpace]", 
   FractionBox["935", "39"], "\[InvisibleSpace]", "\<\"  \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"39", ",", 
     RowBox[{"-", "39"}], ",", "15", ",", 
     RowBox[{"-", "15"}], ",", "55", ",", 
     RowBox[{"-", "55"}]}], "}"}]}],
  SequenceForm["t=", -1, ", b2=", 
   Rational[935, 39], "  ", {39, -39, 15, -15, 55, -55}],
  Editable->False]], "Print",
 CellChangeTimes->{3.775842163431013*^9, 3.775842257291469*^9},
 CellLabel->
  "During evaluation of \
In[34]:=",ExpressionUUID->"69268d5f-8db6-4dbd-a132-4ce2b01bf7b2"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TestP", "[", 
  RowBox[{"11", ",", "3", ",", 
   RowBox[{"131", "/", "13"}], ",", "5", ",", "13"}], "]"}]], "Input",
 CellChangeTimes->{{3.775842187384664*^9, 3.77584219000028*^9}},
 CellLabel->"In[35]:=",ExpressionUUID->"94dc1122-06cf-4de1-ad53-17fbfa60a08a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"t=\"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "1"}], "\[InvisibleSpace]", "\<\", b2=\"\>", 
   "\[InvisibleSpace]", 
   FractionBox["7205", "507"], "\[InvisibleSpace]", "\<\"  \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "39"}], ",", "39", ",", 
     RowBox[{"-", "15"}], ",", "15", ",", 
     RowBox[{"-", "55"}], ",", "55"}], "}"}]}],
  SequenceForm["t=", -1, ", b2=", 
   Rational[7205, 507], "  ", {-39, 39, -15, 15, -55, 55}],
  Editable->False]], "Print",
 CellChangeTimes->{3.7758421915405416`*^9, 3.7758422599287167`*^9},
 CellLabel->
  "During evaluation of \
In[35]:=",ExpressionUUID->"83b1d5e0-f493-4939-8f94-d37944596bec"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TestP", "[", 
  RowBox[{"11", ",", "2", ",", "7", ",", "5", ",", "17"}], "]"}]], "Input",
 CellChangeTimes->{{3.77584126852719*^9, 3.775841279438888*^9}},
 CellLabel->"In[36]:=",ExpressionUUID->"e4f11085-469f-4cf3-952a-694378bff464"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"t=\"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "1"}], "\[InvisibleSpace]", "\<\", b2=\"\>", 
   "\[InvisibleSpace]", 
   FractionBox["385", "34"], "\[InvisibleSpace]", "\<\"  \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "34"}], ",", "34", ",", 
     RowBox[{"-", "10"}], ",", "10", ",", 
     RowBox[{"-", "55"}], ",", "55"}], "}"}]}],
  SequenceForm["t=", -1, ", b2=", 
   Rational[385, 34], "  ", {-34, 34, -10, 10, -55, 55}],
  Editable->False]], "Print",
 CellChangeTimes->{3.775841280300804*^9, 3.77584150276929*^9, 
  3.7758417533471622`*^9, 3.7758418873212137`*^9, 3.7758419358690443`*^9, 
  3.775842262500681*^9},
 CellLabel->
  "During evaluation of \
In[36]:=",ExpressionUUID->"8462b2fd-4574-49f3-8787-45b5c73ae1a6"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TestP", "[", 
  RowBox[{"2", ",", "5", ",", "3", ",", "11", ",", "7"}], "]"}]], "Input",
 CellChangeTimes->{{3.775841304399149*^9, 3.7758413250788317`*^9}},
 CellLabel->"In[37]:=",ExpressionUUID->"f8856ed4-3d9e-4138-8072-74ff4e1332b4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"t=\"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "1"}], "\[InvisibleSpace]", "\<\", b2=\"\>", 
   "\[InvisibleSpace]", 
   FractionBox["66", "35"], "\[InvisibleSpace]", "\<\"  \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "35"}], ",", "35", ",", 
     RowBox[{"-", "55"}], ",", "55", ",", 
     RowBox[{"-", "22"}], ",", "22"}], "}"}]}],
  SequenceForm["t=", -1, ", b2=", 
   Rational[66, 35], "  ", {-35, 35, -55, 55, -22, 22}],
  Editable->False]], "Print",
 CellChangeTimes->{3.775841327017487*^9, 3.775841506301384*^9, 
  3.775841756056587*^9, 3.77584188985548*^9, 3.775841939023808*^9, 
  3.775842265222096*^9},
 CellLabel->
  "During evaluation of \
In[37]:=",ExpressionUUID->"384bf840-295d-4017-81ad-3a7dda3ef026"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TestP", "[", 
  RowBox[{"13", ",", "5", ",", "7", ",", "2", ",", "23"}], "]"}]], "Input",
 CellChangeTimes->{{3.775841525031501*^9, 3.77584154047922*^9}, {
  3.775841588200391*^9, 3.77584173508873*^9}},
 CellLabel->"In[38]:=",ExpressionUUID->"0d9fb0a6-f71a-4536-8a5f-4cb4812beaf7"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"t=\"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "1"}], "\[InvisibleSpace]", "\<\", b2=\"\>", 
   "\[InvisibleSpace]", 
   FractionBox["182", "115"], "\[InvisibleSpace]", "\<\"  \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "115"}], ",", "115", ",", 
     RowBox[{"-", "10"}], ",", "10", ",", 
     RowBox[{"-", "26"}], ",", "26"}], "}"}]}],
  SequenceForm["t=", -1, ", b2=", 
   Rational[182, 115], "  ", {-115, 115, -10, 10, -26, 26}],
  Editable->False]], "Print",
 CellChangeTimes->{{3.7758417386678457`*^9, 3.775841758570204*^9}, 
   3.7758418378989973`*^9, 3.7758418926279593`*^9, 3.7758419423652983`*^9, 
   3.775842268586918*^9},
 CellLabel->
  "During evaluation of \
In[38]:=",ExpressionUUID->"9b2a2b91-248d-4983-99b4-93d6e7d09aad"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TestP", "[", 
  RowBox[{"3", ",", "11", ",", "7", ",", "5", ",", "2"}], "]"}]], "Input",
 CellChangeTimes->{{3.7758419636562977`*^9, 3.775841999801236*^9}},
 CellLabel->"In[39]:=",ExpressionUUID->"e92b9ee1-02ad-4181-a3ef-51e5ca044cbd"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"t=\"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "1"}], "\[InvisibleSpace]", "\<\", b2=\"\>", 
   "\[InvisibleSpace]", 
   FractionBox["105", "22"], "\[InvisibleSpace]", "\<\"  \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "22"}], ",", "22", ",", 
     RowBox[{"-", "55"}], ",", "55", ",", 
     RowBox[{"-", "15"}], ",", "15"}], "}"}]}],
  SequenceForm["t=", -1, ", b2=", 
   Rational[105, 22], "  ", {-22, 22, -55, 55, -15, 15}],
  Editable->False]], "Print",
 CellChangeTimes->{3.7758420003844976`*^9, 3.7758422717891903`*^9},
 CellLabel->
  "During evaluation of \
In[39]:=",ExpressionUUID->"e8d18997-d7dc-4a7c-9b34-ccc6cabbb77a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TestP", "[", 
  RowBox[{"3", ",", "11", ",", "7", ",", "5", ",", "20"}], "]"}]], "Input",
 CellChangeTimes->{{3.775842038032528*^9, 3.775842045887995*^9}},
 CellLabel->"In[40]:=",ExpressionUUID->"9f7f7587-fe17-45f1-9977-f395f3710b31"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"t=\"\>", "\[InvisibleSpace]", 
   RowBox[{"-", "1"}], "\[InvisibleSpace]", "\<\", b2=\"\>", 
   "\[InvisibleSpace]", 
   FractionBox["21", "44"], "\[InvisibleSpace]", "\<\"  \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "44"}], ",", "44", ",", 
     RowBox[{"-", "11"}], ",", "11", ",", 
     RowBox[{"-", "3"}], ",", "3"}], "}"}]}],
  SequenceForm["t=", -1, ", b2=", 
   Rational[21, 44], "  ", {-44, 44, -11, 11, -3, 3}],
  Editable->False]], "Print",
 CellChangeTimes->{3.775842047366049*^9, 3.7758422746919193`*^9},
 CellLabel->
  "During evaluation of \
In[40]:=",ExpressionUUID->"ebaf9e28-6904-4a48-abd3-a9b4ac05be8d"]
}, Open  ]]
},
WindowSize->{808, 911},
WindowMargins->{{Automatic, 845}, {188, Automatic}},
FrontEndVersion->"12.0 for Mac OS X x86 (64-bit) (April 8, 2019)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 1300, 22, 242, "Text",ExpressionUUID->"e3fe5dcd-4659-46ac-917f-8466aef53435"],
Cell[1861, 44, 174, 3, 35, "Text",ExpressionUUID->"a7db9f21-9863-4737-ba43-5b65d529f88c"],
Cell[CellGroupData[{
Cell[2060, 51, 501, 10, 30, "Input",ExpressionUUID->"ce88380c-4612-4430-ad11-b98476848d44"],
Cell[2564, 63, 33450, 525, 340, "Graphics",ExpressionUUID->"ad23f94d-aa3f-4e6a-b93e-7de98c9bfd51"]
}, Open  ]],
Cell[CellGroupData[{
Cell[36051, 593, 3249, 87, 325, "Input",ExpressionUUID->"d1a58d29-23ca-436b-8d66-c9ce23cde1bc"],
Cell[39303, 682, 34572, 537, 212, "Graphics",ExpressionUUID->"fecae20d-e830-4536-91e9-f1518edd81be"]
}, Open  ]],
Cell[73890, 1222, 4439, 139, 535, "Input",ExpressionUUID->"243d8d3b-c993-4e0d-a31b-d158b3681dd9"],
Cell[78332, 1363, 3469, 85, 325, "Input",ExpressionUUID->"ecd911d6-08ee-48a1-b698-fd4effacd353"],
Cell[CellGroupData[{
Cell[81826, 1452, 258, 4, 30, "Input",ExpressionUUID->"318f716f-b1d9-4b24-9d97-87b346cce7b8"],
Cell[82087, 1458, 835, 20, 40, "Print",ExpressionUUID->"d7ab947f-992c-4205-8cc7-e69cf826a92c"]
}, Open  ]],
Cell[CellGroupData[{
Cell[82959, 1483, 283, 5, 30, "Input",ExpressionUUID->"8da35414-adf3-4a38-9302-92f563c14af4"],
Cell[83245, 1490, 739, 19, 40, "Print",ExpressionUUID->"2141bdc8-08c2-4cfc-941e-d5e8f29cc516"]
}, Open  ]],
Cell[CellGroupData[{
Cell[84021, 1514, 284, 5, 30, "Input",ExpressionUUID->"54eb1bba-5cf1-4f8d-a8ae-d34645b089f9"],
Cell[84308, 1521, 739, 19, 40, "Print",ExpressionUUID->"ab5d1008-2296-4504-b89d-14aa234561dc"]
}, Open  ]],
Cell[CellGroupData[{
Cell[85084, 1545, 286, 5, 30, "Input",ExpressionUUID->"0d96ca8e-e1b0-4301-9588-931caa645e0b"],
Cell[85373, 1552, 738, 19, 40, "Print",ExpressionUUID->"ad0e94f5-2a0e-43cb-8f8c-f3719b998c5e"]
}, Open  ]],
Cell[CellGroupData[{
Cell[86148, 1576, 235, 4, 30, "Input",ExpressionUUID->"a37ed5ea-93d6-43eb-9c89-cb07df1ac960"],
Cell[86386, 1582, 712, 18, 40, "Print",ExpressionUUID->"69268d5f-8db6-4dbd-a132-4ce2b01bf7b2"]
}, Open  ]],
Cell[CellGroupData[{
Cell[87135, 1605, 284, 5, 30, "Input",ExpressionUUID->"94dc1122-06cf-4de1-ad53-17fbfa60a08a"],
Cell[87422, 1612, 720, 18, 40, "Print",ExpressionUUID->"83b1d5e0-f493-4939-8f94-d37944596bec"]
}, Open  ]],
Cell[CellGroupData[{
Cell[88179, 1635, 257, 4, 30, "Input",ExpressionUUID->"e4f11085-469f-4cf3-952a-694378bff464"],
Cell[88439, 1641, 811, 20, 40, "Print",ExpressionUUID->"8462b2fd-4574-49f3-8787-45b5c73ae1a6"]
}, Open  ]],
Cell[CellGroupData[{
Cell[89287, 1666, 259, 4, 30, "Input",ExpressionUUID->"f8856ed4-3d9e-4138-8072-74ff4e1332b4"],
Cell[89549, 1672, 803, 20, 40, "Print",ExpressionUUID->"384bf840-295d-4017-81ad-3a7dda3ef026"]
}, Open  ]],
Cell[CellGroupData[{
Cell[90389, 1697, 305, 5, 30, "Input",ExpressionUUID->"0d9fb0a6-f71a-4536-8a5f-4cb4812beaf7"],
Cell[90697, 1704, 824, 20, 40, "Print",ExpressionUUID->"9b2a2b91-248d-4983-99b4-93d6e7d09aad"]
}, Open  ]],
Cell[CellGroupData[{
Cell[91558, 1729, 259, 4, 30, "Input",ExpressionUUID->"e92b9ee1-02ad-4181-a3ef-51e5ca044cbd"],
Cell[91820, 1735, 716, 18, 40, "Print",ExpressionUUID->"e8d18997-d7dc-4a7c-9b34-ccc6cabbb77a"]
}, Open  ]],
Cell[CellGroupData[{
Cell[92573, 1758, 258, 4, 30, "Input",ExpressionUUID->"9f7f7587-fe17-45f1-9977-f395f3710b31"],
Cell[92834, 1764, 708, 18, 40, "Print",ExpressionUUID->"ebaf9e28-6904-4a48-abd3-a9b4ac05be8d"]
}, Open  ]]
}
]
*)

